<!DOCTYPE html>

<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title><?php echo e(Setting::get('site_name')); ?></title>

        <meta name="robots" content="noindex">

        <meta name="description" content="<?php echo e(Setting::get('meta_description')); ?>">

        <meta name="author" content="<?php echo e(Setting::get('meta_author')); ?>">

        <meta name="keywords" content="<?php echo e(Setting::get('meta_keywords')); ?>">

        <link href="<?php echo e(asset('common/css/bootstrap.min.css')); ?>" rel="stylesheet">

        <?php echo $__env->yieldContent('before-styles'); ?>

        <link href="<?php echo e(asset('common/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">

        <link href="<?php echo e(asset('common/ionicons/css/ionicons.min.css')); ?>" rel="stylesheet">

        <link href="<?php echo e(asset('common/css/style.css')); ?>" rel="stylesheet">

        <link href="<?php echo e(asset('common/css/responsive.css')); ?>" rel="stylesheet">

        <link rel="shortcut icon" type="image/png" href="<?php echo e(Setting::get('site_icon')); ?>"/>

        <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('icons/apple-icon-57x57.png')); ?>">
        <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('icons/apple-icon-60x60.png')); ?>">
        <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('icons/apple-icon-72x72.png')); ?>">
        <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('icons/apple-icon-76x76.png')); ?>">
        <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('icons/apple-icon-114x114.png')); ?>">
        <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('icons/apple-icon-120x120.png')); ?>">
        <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('icons/apple-icon-144x144.png')); ?>">
        <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('icons/apple-icon-152x152.png')); ?>">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('icons/apple-icon-180x180.png')); ?>">
        <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo e(asset('icons/android-icon-192x192.png')); ?>">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('icons/favicon-32x32.png')); ?>">
        <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('icons/favicon-96x96.png')); ?>">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('icons/favicon-16x16.png')); ?>">
        <link rel="manifest" href="<?php echo e(asset('icons/manifest.json')); ?>">
        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="msapplication-TileImage" content="<?php echo e(asset('icons/ms-icon-144x144.png')); ?>">
        <meta name="theme-color" content="#ffffff">

        <?php echo $__env->yieldContent('after-styles'); ?>

        <style>
            .navbar-nav a {
                text-transform: uppercase;
            }
        </style>

    </head>

    <body>

        <div id="preloader">
            
            <div class="cssload-container">
                <div class="cssload-item cssload-moon"></div>
            </div>

        </div>

        <div class="main-content">

            <?php echo $__env->make('layouts.user.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <?php echo $__env->yieldContent('content'); ?>

            <?php echo $__env->make('layouts.common.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>

        <script src="<?php echo e(asset('common/js/jquery.min.js')); ?>"></script>

        <script src="<?php echo e(asset('common/js/bootstrap.min.js')); ?>"></script>

        <?php echo $__env->yieldContent('before-scripts'); ?>

        <script src="<?php echo e(asset('common/js/slick.min.js')); ?>"></script>

        <script src="<?php echo e(asset('common/js/scripts.js')); ?>"></script>

        <script>            
            $(window).load(function(){
                $('#preloader').fadeOut(2000);
            });
        </script>

        <?php if(Auth::check()): ?> 

            <?php if(Setting::get('user_notification_control')): ?>

            <script type="text/javascript">
                
                window.setInterval(function() {

                    $.ajax({
                        'url' : '<?php echo e(url("/api/user/user_notifications")); ?>',
                        'type' : 'post',
                        data : {id : "<?php echo e(Auth::user()->id); ?>", token : "<?php echo e(Auth::user()->token); ?>"},
                        'success' : function(response) {

                              // $("#append_value").html('');

                              // var list  = [];

                              if (response.cnt > 0) {

                                    $('.bell_badge .cnt').show();


                              } else {
                                    
                                    $('.bell_badge .cnt').hide();
                              }

                            $(".cnt").html(response.cnt);

                            //$('.confirmed_job_badge').html(response.confirmed_requests);

                            //$('.ongoing_job_badge').html(response.ongoing_requests);


                           //  console.log(list);


                            // $("#append_value").html(list);


                			$('.confirmed_job_badge').hide();

                            $('.ongoing_job_badge').hide();

                            if (parseInt(response.confirmed_requests) > 0) {

                                $('.confirmed_job_badge').show();

                                $('.confirmed_job_badge').html(response.confirmed_requests);

                            }   

                            if (parseInt(response.ongoing_requests) > 0) {

                                $('.ongoing_job_badge').show();

                                $('.ongoing_job_badge').html(response.ongoing_requests);

                            }


                        }
                    
                    });
                
                }, 5000);

                $("#notify_click").click(function() {

                    $.ajax({
                        'url' : '<?php echo e(url("/api/user/change_status_notifications")); ?>',
                        'type' : 'post',
                        data : {id : "<?php echo e(Auth::user()->id); ?>", token : "<?php echo e(Auth::user()->token); ?>"},    
                        'success' : function(response) {

                            var list = [];

                            for(var i = 0; i < response.cnt; i++) {

                                var obj = response.notifications[i];

                                var ui = '<li style="border-bottom:1px solid #ddd;">'+
                                            '<a target="_blank" href="'+obj.url+'">'+
                                                '<div style="padding: 3px 5px">'+
                                                    '<div class="col-md-2 col-sm-2 col-xs-2">'+
                                                        '<div class="incoming-img bg-img" style="background-image:url('+obj.picture+');width: 40px;height: 40px">'+
                                                        '</div>'+
                                                    '</div>'+
                                                    '<div class="col-md-8 col-sm-8 col-xs-8">'+
                                                        '<p class="notification_text">'+obj.notification+'</p>'+
                                                        '<p>'+obj.created_at+'</p>'+
                                                    '</div>'+
                                                    '<div class="clearfix"></div>'+
                                                '</div>'+
                                            '</a>'+
                                        '</li>';

                                list.push(ui);

                            }

                            $("#append_value").html(list);

                        }
                    
                    });

                });

            </script>

            <?php endif; ?>


        <?php endif; ?>

        <script type="text/javascript">
            <?php if(isset($header_page)): ?>
                $("#<?php echo e($header_page); ?>").addClass("header-active");

            <?php endif; ?>
        </script>

        <?php echo $__env->yieldContent('after-scripts'); ?>

        <?php echo Setting::get('google_analytics'); ?>

    </body>

</html>