<?php $__env->startSection('title', tr('view_user')); ?>

<?php $__env->startSection('content-header', tr('view_user')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li><a href="<?php echo e(route('admin.users.index')); ?>"><i class="fa fa-user"></i> <?php echo e(tr('users')); ?></a></li>
    <li class="active"> <?php echo e(tr('view_user')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<style type="text/css">
		.timeline::before {
		    content: '';
		    position: absolute;
		    top: 0;
		    bottom: 0;
		    width: 0;
		    background: #fff;
		    left: 0px;
		    margin: 0;
		    border-radius: 0px;
		}
	</style>

	<div class="row">

		<div class="col-md-9 col-md-offset-1">

		<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    		<div class="box box-widget widget-user-2">

            	<div class="widget-user-header bg-primary">

              		<div class="widget-user-image">

                		<img class="img-circle" src="<?php if($user_details->picture): ?> <?php echo e($user_details->picture); ?> <?php else: ?> <?php echo e(asset('admin-css/dist/img/avatar.png')); ?> <?php endif; ?>" alt="User Avatar">

              		</div>

              		<h3 class="widget-user-username"><?php echo e($user_details->name); ?> </h3>

      				<h5 class="widget-user-desc"><?php echo e(tr('user')); ?></h5>

            	</div>

            	<div class="box-footer no-padding">

            		<div class="col-md-7">
            		
	              		<ul class="nav nav-stacked">

			                <li><a><?php echo e(tr('unique_id')); ?> <b><span class="pull-right"><?php echo e($user_details->unique_id); ?></span></b></a></li>

			                <li><a><?php echo e(tr('username')); ?> <b><span class="pull-right"><?php echo e($user_details->name); ?></span></b></a></li>

			                <li><a ><?php echo e(tr('email')); ?> <b><span class="pull-right"><?php echo e($user_details->email); ?></span></b></a></li>

			                <li><a><?php echo e(tr('mobile')); ?> <b><span class="pull-right"><?php echo e($user_details->mobile); ?></span></b></a></li>
			               
			                <li>
			                	<a><?php echo e(tr('is_verified')); ?> 
				                <?php if($user_details->is_verified == USER_EMAIL_VERIFIED): ?>
				                	<b><span class="label label-success pull-right"><?php echo e(tr('yes')); ?></span></b>
				            	<?php else: ?> 			                		
			                		<?php echo e(tr('verified')); ?>

			                		<b><span class="label label-warning pull-right"><?php echo e(tr('no')); ?></span></b>
								<?php endif; ?> 
								</a>
							</li>
							
							<li>
								<a>
								<?php if($user_details->status == USER_APPROVED): ?>
			                		<?php echo e(tr('status')); ?>

				                	<span class="label label-success pull-right"><?php echo e(tr('approved')); ?></span>
				            	<?php else: ?> 
			                		<?php echo e(tr('status')); ?>

			                		<span class="label label-warning pull-right"><?php echo e(tr('pending')); ?></span>
								<?php endif; ?>
								</a>
							</li>

			                <li>
			                	<a><?php echo e(tr('joined')); ?> 
			                		<b>
			                			<span class="pull-right">
			                				<?php echo e(common_date($user_details->created_at , Auth::guard('admin')->user()->timezone)); ?>

			                			</span>
			                		</b>
			                	</a>
			                </li>

			                <li>
			                	<a><?php echo e(tr('updated')); ?> 
			                		<b>
			                			<span class="pull-right">
			                				<?php echo e(common_date($user_details->updated_at , Auth::guard('admin')->user()->timezone)); ?>

			                			</span>
			                		</b>
			                	</a>
			                </li>

	              		</ul>

              		</div>

              		<div class="col-md-5">

              			<ul class="nav nav-stacked">

			                <li><a><?php echo e(tr('payment_mode')); ?> <span class="pull-right text-uppercase"><b><?php echo e($user_details->payment_mode); ?></span></b></a></li>

			                <li><a><?php echo e(tr('device_type')); ?> <span class="pull-right text-uppercase"><b><?php echo e($user_details->device_type); ?></span></b></a></li>

			                <li><a><?php echo e(tr('login_by')); ?> <span class="pull-right text-uppercase"><b><?php echo e($user_details->login_by); ?></span></b></a></li>

			                <li><a><?php echo e(tr('login_status')); ?> <span class="pull-right text-uppercase"><b><?php echo e($user_details->login_status); ?></span></b></a></li>

			                <li><a><?php echo e(tr('register_type')); ?> <span class="pull-right text-uppercase"><b><?php echo e($user_details->register_type); ?></span></b></a></li>

			                <li><a><?php echo e(tr('timezone')); ?> <span class="pull-right text-uppercase"><b><?php echo e($user_details->timezone); ?></span></b></a></li>

	              		</ul>

              		</div>

              		<div class="clearfix"></div>

              		<div class="col-md-7">

              			<ul class="nav nav-stacked">

			                <li>
			                	<a><?php echo e(tr('user_email_notification')); ?> 
			                		 
		                			<?php if($user_details->email_notification_status == ON): ?>			                		
		                				<b><span class="label label-success pull-right"><?php echo e(tr('on')); ?></span></b>

		                			<?php else: ?>

				                		<b><span class="label label-danger pull-right"><?php echo e(tr('off')); ?></span></b>
		                			<?php endif; ?>
			                	</a>
			                </li>

			                <li>
			                	<a><?php echo e(tr('user_push_notification')); ?> 

			                		<?php if($user_details->push_notification_status == ON): ?>
	                			
		                				<b><span class="label label-success pull-right"><?php echo e(tr('on')); ?></span></b>

		                			<?php else: ?>
		                				
		                				<b><span class="label label-danger pull-right"><?php echo e(tr('on')); ?></span></b>

		                			<?php endif; ?>
			                	</a>
			                </li>

			                <li>
			                	<a>
			                		<b><?php echo e(tr('userdescription')); ?> : </b> <p class="text-justify"><?php echo e($user_details->description); ?></p>
			                	</a>
			                </li>

	              		</ul>

              		</div>

              		<!-- Totally job request status information part 
              		 Totall number of request , cancelled request , completed request -->

              		<div class="col-md-5">

              			<ul class="nav nav-stacked">

              				<li>
			                	<div style="padding: 10px 20px"><b><?php echo e(tr('job_info')); ?></b></div>
			                </li>

			                <li>
			                	<a><?php echo e(tr('total')); ?> <span class="pull-right"><?php echo e($user_details->userRequests()->count()); ?></span></a>
			                </li>

			                <li>
			                	<a><?php echo e(tr('completed_jobs')); ?> <span class="pull-right"><?php echo e($user_details->userRequests()->whereIn('requests.status',[REQUEST_COMPLETED,REQUEST_RATING])->count()); ?></span></a>
			                </li>
			                
			                <li>
			                	<a><?php echo e(tr('cancelled_jobs')); ?> <span class="pull-right"><?php echo e($user_details->userRequests()->whereIn('requests.status',[REQUEST_CANCELLED])->count()); ?></span></a>
			                </li>

	              		</ul>


						<?php if(count($users_referral_details) > 0 ): ?>
						 <!-- @todo  Wallet modeule to be done hence hidden referral_settings -->

						<ul class="nav nav-stacked" style="display: none">

              				<li>
			                	<div style="padding: 10px 20px"><b><?php echo e(tr('referral_details')); ?></b></div>
			                </li>

						
							<li>
			            		<a><?php echo e(tr('referral_code')); ?><span class="pull-right">
			            		 <?php echo e($users_referral_details->referral_code); ?> </span></a>
			            	</li>	

			                <li>
			            		<a><?php echo e(tr('referral_earnings')); ?><span class="pull-right">
			            		<?php echo e(Setting::get('currency')); ?> <?php echo e($users_referral_details->total_referrals_earnings); ?> </span></a>
			            	</li>
			            	
			            	<li>
			            		<a href="<?php echo e(route('admin.users.referral.index',['user_id' => $users_referral_details->user_id, 'user_referrer_id' => $users_referral_details->id ])); ?>"><?php echo e(tr('referral_count')); ?>

			            		
			            		<span class="pull-right" class="text-info"> <?php echo e($users_referral_details->total_referrals); ?> </span></a> 

			            		
			            	</li>
		            		</ul>
		            	<?php endif; ?>

              		</div>

            	</div>

            	<div class="box-footer label-default">

            		<?php if(Setting::get('admin_demo_control')): ?>

						<a href="javascript:;" class="btn btn-warning  disabled  text-center"><b><?php echo e(tr('edit')); ?></b></a>

						<a href="javascript:;" class="btn btn-danger disabled text-center"><b><?php echo e(tr('delete')); ?></b></a>

					<?php else: ?>

						<a href="<?php echo e(route('admin.users.edit' , ['user_id' => $user_details->id] )); ?>" class="btn btn-warning  text-center"><b><?php echo e(tr('edit')); ?></b></a>

						<a class="btn btn-danger text-center" onclick="return confirm(&quot;<?php echo e(tr('admin_user_delete_confirmation' , $user_details->name)); ?>&quot;);"  href="<?php echo e(route('admin.users.delete', ['user_id' => $user_details->id] )); ?>">
						    <b><?php echo e(tr('delete')); ?></b>
						</a>

					<?php endif; ?>	

					<?php if($user_details->status == USER_APPROVED): ?>
							
              			<a href="<?php echo e(route('admin.users.status' , [ 'user_id' => $user_details->id ] )); ?>" onclick="return confirm(&quot;<?php echo e($user_details->name); ?> - <?php echo e(tr('user_decline_confirmation')); ?>&quot;);" class="btn btn-danger text-center"><b><?php echo e(tr('decline')); ?></b></a>
             
                  	<?php else: ?>

              			<a href="<?php echo e(route('admin.users.status' , [ 'user_id' => $user_details->id ] )); ?>" class="btn btn-success text-center"><b><?php echo e(tr('approve')); ?></b></a>
                  		
                  	<?php endif; ?>

					<a href="<?php echo e(route('admin.users.history', ['user_id' => $user_details->id] )); ?>" class="btn btn-info  pull-right"><b><?php echo e(tr('view_history')); ?></b></a>

					<a href="<?php echo e(route('admin.users.fav_providers', ['user_id' => $user_details->id] )); ?>" class="btn btn-success  text-center"><b><?php echo e(tr('fav_providers')); ?></b></a>


					
            	</div>
          	
          	</div>

		</div>

    </div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>