<?php $__env->startSection('after-styles'); ?>

<style>
	.truncate {
	  width: 15em;
	  white-space: nowrap;
	  overflow: hidden;
	  text-overflow: ellipsis;
	}
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<div class="content-wrap gray-bg">

		<div class="container">

			<?php if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING): ?>
		    
		        <div class="alert alert-danger text-uppercase" style="margin-top: 10px;">
		            <?php echo e(tr('provider_waiting_for_admin_approval')); ?>

		        </div>

		    <?php endif; ?>
	

			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			<div class="jobs white-bg m-30 p-f-30">

				<div class="tab-content job-content">

					<!-- Drafts tab -->
					<div role="tabpanel" class="tab-pane fade in active" id="new-requests">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0">
						
							<h3 class="job-main-tit" style="margin-bottom: 10px">

								<?php echo e(tr('history')); ?> ( <?php echo e(count($requests)); ?> <?php echo e(tr('jobs')); ?>)

								<a href="<?php echo e(route('provider.history',['cancelled_jobs' => YES])); ?>" class="btn text-uppercase text-underline pull-right">
									<i class="fa fa-ban"></i> <?php echo e(tr('cancelled_jobs')); ?>

								</a>

							</h3>

							<div class="dashboard-list-outer">
								<!-- DAshboard list -->

								<?php if($requests): ?>

									<?php foreach($requests as $pr => $request_details): ?>
								
										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-5 col-md-5 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit job_name"><?php echo e($request_details->name); ?></h3>
													<p class="dashboard-list-txt">
														<span><b><?php echo e(tr('request_date')); ?> : </b> <?php echo e($request_details->request_date); ?> </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left truncate"></i> <?php echo e(Setting::get('currency')); ?> <?php echo e($request_details->total); ?><?php echo e($request_details->price_per_symbol); ?>

													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> <?php echo e($request_details->user_name); ?>

													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-thumbs-up"></i>
													 	<?php echo e(request_status($request_details->status)); ?>

													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">

													<a href="<?php echo e(route('provider.requests.view' , ['request_unique_id' => $request_details->unique_id])); ?>" class="view-link theme-btn m-t-20"><i class="fa fa-eye"></i> <?php echo e(tr('view')); ?></a>	

																					
												</div>
											</div>
											<!-- End of dashboard-list-box -->
										</div>

									<?php endforeach; ?>

								<?php else: ?>
								
									<!-- <h1 class="text-center theme-color"><i class="fa fa-spinner"></i></h1> -->

									<h3 class="text-center"><?php echo e(tr('no_result_content')); ?></h3>
								<?php endif; ?>
							
							</div>

						</div>

						<!-- End of job details list -->
					
					</div>

				</div>
			</div>

		</div>

	</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.provider', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>