<?php $__env->startSection('title', tr('profile')); ?>

<?php $__env->startSection('content-header', tr('profile')); ?>

<?php $__env->startSection('breadcrumb'); ?>

    <li><a href="#"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>

    <li class="active"><i class="fa fa-diamond"></i> <?php echo e(tr('account')); ?></li>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>

<style>
    .nav-tabs-custom>.nav-tabs>li.active {
        border-top-color: #00a65a;
    }
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">

        <div class="col-md-4">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <h5 class="box-title text-uppercase"><?php echo e(tr('profile')); ?></h5>

                </div>

                <div class="box-body box-profile">

                    <img class="profile-user-img img-responsive img-circle" src="<?php if($admin_details->picture): ?> <?php echo e($admin_details->picture); ?> <?php else: ?> <?php echo e(asset('placeholder.png')); ?> <?php endif; ?>" alt="Picture">

                    <h3 class="profile-username text-center"><?php echo e($admin_details->name); ?></h3>

                    <p class="text-muted text-center"><?php echo e(tr('admin')); ?></p>

                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                            <b><?php echo e(tr('username')); ?></b> <a class="pull-right"><?php echo e($admin_details->name); ?></a>
                        </li>
                        <li class="list-group-item">
                            <b><?php echo e(tr('email')); ?></b> <a class="pull-right"><?php echo e($admin_details->email); ?></a>
                        </li>

                        <li class="list-group-item">
                            <b><?php echo e(tr('mobile')); ?></b> <a class="pull-right"><?php echo e($admin_details->mobile); ?></a>
                        </li>

                        <li class="list-group-item">
                            <b><?php echo e(tr('address')); ?></b> <a class="pull-right"><?php echo e($admin_details->address); ?></a>
                        </li>
                    </ul>
                
                </div>

            </div>

        </div>

         <div class="col-md-8">
            <div class="nav-tabs-custom">

                <ul class="nav nav-tabs">
                    <li class="active"><a href="#adminprofile" data-toggle="tab"><?php echo e(tr('update_profile')); ?></a></li>
                    <li><a href="#image" data-toggle="tab"><?php echo e(tr('upload_image')); ?></a></li>
                    <li><a href="#password" data-toggle="tab"><?php echo e(tr('change_password')); ?></a></li>
                </ul>
               
                <div class="tab-content">
                   
                    <div class="active tab-pane" id="adminprofile">

                        <?php if(Setting::get('admin_demo_control')): ?>

                            <form class="form-horizontal" action="#" role="form">

                        <?php else: ?>

                            <form class="form-horizontal" action="<?php echo e(route('admin.profile.save')); ?>" method="POST" enctype="multipart/form-data" role="form">
                            
                        <?php endif; ?>

                            <input type="hidden" name="id" value="<?php echo e($admin_details->id); ?>">

                            <div class="form-group">
                                <label for="name" required class="col-sm-2 control-label"><?php echo e(tr('username')); ?></label>
                                <div class="col-sm-10">
                                  <input type="text" class="form-control" id="name"  name="name" value="<?php echo e(old('name') ?: $admin_details->name); ?>" placeholder="<?php echo e(tr('username')); ?>" onkeydown="return alphaOnly(event);" >
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="email" class="col-sm-2 control-label"><?php echo e(tr('email')); ?></label>

                                <div class="col-sm-10">
                                  <input type="email" required value="<?php echo e(old('email') ?: $admin_details->email); ?>" name="email" class="form-control" id="email" placeholder="<?php echo e(tr('email')); ?>">
                                </div>
                            </div>


                            <div class="form-group">
                                <label for="mobile" class="col-sm-2 control-label"><?php echo e(tr('mobile')); ?></label>

                                <div class="col-sm-10">
                                  <input type="text" value="<?php echo e(old('mobile') ?: $admin_details->mobile); ?>" name="mobile" class="form-control" id="mobile" placeholder="<?php echo e(tr('mobile')); ?>" onkeypress="return isNumber(event)" minlength="6" maxlength="16">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="address" class="col-sm-2 control-label"><?php echo e(tr('address')); ?></label>

                                <div class="col-sm-10">
                                  <input type="text" value="<?php echo e(old('address') ?: $admin_details->address); ?>" name="address" class="form-control" id="address" placeholder="<?php echo e(tr('address')); ?>">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                  <button type="submit" class="btn btn-danger" <?php if(Setting::get('admin_demo_control')): ?> disabled <?php endif; ?>><?php echo e(tr('submit')); ?></button>
                                </div>
                            </div>

                        </form>
                    </div>

                    <div class="tab-pane" id="image">

                        <?php if(Setting::get('admin_demo_control')): ?>

                            <form class="form-horizontal" action="#" role="form">

                        <?php else: ?>

                            <form class="form-horizontal" action="<?php echo e(route('admin.profile.save')); ?>" method="POST" enctype="multipart/form-data" role="form">

                        <?php endif; ?>

                            <input type="hidden" name="id" value="<?php echo e($admin_details->id); ?>">

                            <?php if($admin_details->picture): ?>
                                <img style="height: 90px; margin-bottom: 15px; border-radius:2em;" src="<?php echo e($admin_details->picture); ?>">
                            <?php else: ?>
                                <img style="margin-left: 15px;margin-bottom: 10px" class="profile-user-img img-responsive img-circle"  src="<?php echo e(asset('placeholder.png')); ?>">
                            <?php endif; ?>

                            <div class="form-group">
                                <label for="picture" class="col-sm-2 control-label"><?php echo e(tr('picture')); ?></label>

                                <div class="col-sm-10">
                                  <input type="file" required class="form-control" name="picture" id="picture" accept="image/png,image/jpeg" onchange="loadFile(this)">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                  <button type="submit" class="btn btn-danger" <?php if(Setting::get('admin_demo_control')): ?> disabled <?php endif; ?>><?php echo e(tr('submit')); ?></button>
                                </div>
                            </div>

                        </form>
                    </div>

                    <div class="tab-pane" id="password">

                        <?php if(Setting::get('admin_demo_control')): ?>

                            <form class="form-horizontal" action="#" role="form">

                        <?php else: ?>
                        
                            <form class="form-horizontal" action="<?php echo e(route('admin.change.password')); ?>" method="POST" enctype="multipart/form-data" role="form">

                        <?php endif; ?>

                            <input type="hidden" name="id" value="<?php echo e($admin_details->id); ?>">

                            <div class="form-group">
                                <label for="old_password" class="col-sm-3 control-label"><?php echo e(tr('old_password')); ?></label>

                                <div class="col-sm-8">
                                    <input required type="password" class="form-control" name="old_password" id="old_password" placeholder="<?php echo e(tr('old_password')); ?>">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="password" class="col-sm-3 control-label"><?php echo e(tr('new_password')); ?></label>

                                <div class="col-sm-8">
                                    <input required type="password" class="form-control" name="password" id="password" placeholder="<?php echo e(tr('new_password')); ?>">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="password_confirmation" class="col-sm-3 control-label"><?php echo e(tr('password_confirmation')); ?></label>

                                <div class="col-sm-8">
                                    <input required type="password" class="form-control" name="password_confirmation" id="password_confirmation" placeholder="<?php echo e(tr('password_confirmation')); ?>">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                    <button type="submit" class="btn btn-danger" <?php if(Setting::get('admin_demo_control')): ?> disabled <?php endif; ?> ><?php echo e(tr('submit')); ?></button>
                                </div>
                            </div>

                        </form>

                    </div>

                </div>

            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>