<?php $__env->startSection('after-styles'); ?>
<style>
	.btn-default.active {
		color: #fff !important;
	    background-color: #51af33 !important;
	    border-color: #51af33 !important;
	}
	.set-payment {
		    box-shadow: 0px 1px 2px 1px #e1e1e1;
    	padding-bottom: 20px;
	}
	.heading-underline {
		width: 11% !important;
	    display: block;
	    border: 1px solid #51af33;
	}
</style>

<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/card.css')); ?>" />

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30">
		
		<div class="container">

			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			<h3 class="dashboard-main-tit"><?php echo e(tr('your_account')); ?></h3>

			<!-- Dashboard Left -->
			<div class="dashboard-left-col col-lg-3 col-md-3 col-sm-12 col-xs-12">
			
				<div class="dashboard-left">
					<!-- Nav tabs -->
					<ul class="nav nav-tabs profile-tabs white-bg" role="tablist">
						<div class="text-center profile-left-img-block">
							<a href="#" class="profile-left-img bg-img" style="background-image: url(<?php echo e(Auth::user()->picture); ?>);"></a>
						</div>

						<?php if(Session::has('profile_active')): ?>
							<?php $profile_id = Session::get('profile_active'); ?>

						<?php endif; ?>

					    <?php if(isset($profile_active)): ?>

							<?php $profile_id = $profile_active; ?>
					        
						<?php endif; ?>

					    <li role="presentation" <?php if(isset($profile_id)): ?> <?php if($profile_id == 'profile'): ?> class="active" <?php endif; ?> <?php else: ?> class="active" <?php endif; ?>>
					    	<a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">
					    		<i class="theme-color ion-person"></i>
					    		<?php echo e(tr('profile')); ?>

					    	</a>
					    </li>
					    
					    <li role="presentation" <?php if(isset($profile_id)): ?> <?php if($profile_id == 'billing'): ?> class="active" <?php endif; ?> <?php endif; ?>>
					    	<a href="#billing" aria-controls="billing" role="tab" data-toggle="tab">
					    		<i class="theme-color ion-card"></i>
					    		<?php echo e(tr('billing_info')); ?>

					    	</a>
					    </li>

					    <li role="presentation" <?php if(isset($profile_id)): ?> <?php if($profile_id == 'fav_providers'): ?> class="active" <?php endif; ?> <?php endif; ?>>
					    	<a href="#fav_providers" aria-controls="fav_providers" role="tab" data-toggle="tab">
					    		<i class="theme-color fa fa-heart"></i>
					    		<?php echo e(tr('fav_providers')); ?>

					    	</a>
					    </li> 

					    <!-- @todo  Wallet modeule to be done hence hidden referral_settings -->
					    <li role="presentation" <?php if(isset($profile_id)): ?> <?php if($profile_id == 'referrals'): ?> class="active" <?php endif; ?> <?php endif; ?> style="display: none">
					    	<a href="<?php echo e(route('user.referrals')); ?>" >
					    		<i class="theme-color fa fa-heart"></i>
					    		<?php echo e(tr('referral')); ?>

					    	</a>
					    </li>
					    
					    <?php if(Auth::user()->login_by == "manual"): ?>
						    <li role="presentation" <?php if(isset($profile_id)): ?> <?php if($profile_id == 'change_password'): ?> class="active" <?php endif; ?> <?php endif; ?>>
						    	<a href="#change_password" aria-controls="change-pwd" role="tab" data-toggle="tab">		<i class="theme-color ion-locked"></i>
						    		<?php echo e(tr('change_password')); ?>

						    	</a>
						    </li>
					    <?php endif; ?>
					    
					    <li role="presentation" <?php if(isset($profile_id)): ?> <?php if($profile_id == 'delete_account'): ?> class="active" <?php endif; ?> <?php endif; ?>>
					    	<a href="#delete_account" aria-controls="delete-acc" role="tab" data-toggle="tab">
					    		<i class="theme-color ion-trash-a"></i>
					    		<?php echo e(tr('delete_account')); ?>

					    	</a>
					    </li>

					    <li role="presentation">
					    	<a href="<?php echo e(route('user.logout')); ?>">
					    		<i class="theme-color ion-log-out"></i>
					    		<?php echo e(tr('logout')); ?>

					    	</a>
					    </li>
					</ul>
				</div>

			</div>
			<!-- end of dashboard left -->

			<!-- Dashboard Right -->
			<div class="dashboard-right-col col-lg-9 col-md-9 col-sm-12 col-xs-12">
				
				<div class="dashboard-right tab-content white-bg p-f-30">
					<!-- Profile Tab -->
					<div role="tabpanel" class="tab-pane <?php if(isset($profile_id)): ?> <?php if($profile_id == 'profile'): ?> active in <?php endif; ?> <?php else: ?> in active <?php endif; ?>" id="profile">

						<div class="row m-0 border-bot">
							<h3 class="dashboard-sub-tit pull-left"><?php echo e(tr('account')); ?></h3>
							<a href="javascript:void(0);" class="edit-link pull-right green-border-link"><?php echo e(tr('edit')); ?></a>
						</div>
						
						<div class="profile-sec dashboard-tab-sec p-30">
							<div class="profile-details row m-0">
								<!-- profile-sec-left -->
								<div class="profile-sec-left-col col-lg-4 col-md-4 col-sm-4 col-xs-12">
									<div class="profile-sec-left text-center">
										<div class="profile-img bg-img" style="background-image: url(<?php echo e(Auth::user()->picture); ?>);"></div>
									</div>
								</div>
								<!-- End of profile sec left -->
								<!-- profile sec right -->
								<div class="profile-sec-right-col col-lg-8 col-md-8 col-md-8 col-xs-12">
									<div class="profile-sec-right">
										<p class="profile-sec-txt">
											<span class="profile-details-icon"><i class="theme-color ion-person"></i></span>
											<span><?php echo e(Auth::user()->name); ?></span>
										</p>
										<?php if(Auth::user()->login_by == "manual"): ?>
										<p class="profile-sec-txt">
											<span class="profile-details-icon"><i class="theme-color ion-email"></i></span>
											<span><?php echo e(Auth::user()->email); ?></span>
										</p>
										<?php endif; ?>
										<p class="profile-sec-txt">
											<span class="profile-details-icon"><i class="theme-color ion-ios-telephone"></i></span>
											<span><?php echo e(Auth::user()->mobile); ?></span>
										</p>
										<p class="profile-sec-txt">
											<span class="profile-details-icon"><i class="theme-color fa fa-file-text"></i></span>
											<span><?php echo e(Auth::user()->description); ?></span>
										</p>
										<div class="logout-btn">
											<a href="<?php echo e(route('user.logout')); ?>" class="logout"><?php echo e(tr('logout')); ?></a>
										</div>
									</div>
								</div>
								<!-- End of profile sec right -->
							</div>

							<div class="profile-details-edit row m-0">
								<!-- profile-details-left -->
								<div class="profiles-edit-left-col col-lg-4 col-md-4 col-sm-4 col-xs-12">
									<div class="profile-edit-left text-center">	
										<label><?php echo e(tr('upload_photo')); ?></label> 
		                                <div class="profile-img-blk">
		                                    <div class="img_outer">
		                                        <img class="profile_preview" id="profile_image_preview" src="<?php echo e(Auth::user()->picture); ?>" alt="your image"/>
		                                    </div>


		                                <!-- BECAUSE OF THE PICTURE UPLAOD , THE FORM IS PLACED HERE . DON'T CHNAGE.-->

										<form class="profile-edit-form" action="<?php echo e(route('user.profile.save')); ?>" method="POST" enctype="multipart/form-data">

		                                    <div class="fileUpload up-btn profile-up-btn">                   
		                                        <input type="file" name="picture" id="profile_img_upload_btn" class="upload" accept="image/x-png, image/jpeg"/>
		                                    </div>                     
		                                </div>
	                                </div> 
								</div>
								<!-- End of profile-details-left -->
								<!-- profile-details-right -->
								<div class="profiles-edit-right-col col-lg-8 col-md-8 col-sm-8 col-xs-12">
									<div class="profile-edit-right">

											<div class="form-group">

												<label><?php echo e(tr('name')); ?></label>

												<input type="text" class="form-control" pattern="[a-zA-Z,0-9\s\-\.]{2,100}" name="name" placeholder="<?php echo e(tr('name')); ?>" value="<?php echo e(Auth::user()->name); ?>">

											</div>
											
											<?php if(Auth::user()->login_by == "manual"): ?>
											
												<div class="form-group">

													<label><?php echo e(tr('email')); ?></label>

													<input type="email" class="form-control" name="email" value="<?php echo e(Auth::user()->email); ?>" placeholder="<?php echo e(tr('email')); ?>">
												</div>

											<?php endif; ?>

											<div class="form-group">

												<label><?php echo e(tr('mobile')); ?></label>

												<input type="number" required class="form-control"  minlength="4" maxlength="16" pattern="[0-9]{4,16}" name="mobile" placeholder="<?php echo e(tr('mobile')); ?>" value="<?php echo e(Auth::user()->mobile); ?>">
											</div>

											<div class="form-group">
												<label><?php echo e(tr('description')); ?> <span class="theme-color"><?php echo e(tr('user_description_limit_content')); ?></span></label>
												<textarea class="form-control" rows="4" maxlength="150" style="resize: none" name="description" placeholder="<?php echo e(tr('description')); ?>"><?php echo e(Auth::user()->description); ?></textarea>
											</div>

											<div>
												<button type="cancel" class="cancel-btn form-btn"><?php echo e(tr('cancel')); ?></button>

												<button type="submit" class="save-btn form-btn"><?php echo e(tr('update')); ?></button>

											</div>

										</form>
									</div>
								</div>
								<!-- End of profile-details-right -->
							
							</div>

						</div>
					
					</div>
					<!-- End of Profile tab -->

					<!-- Billing tab -->
					<div role="tabpanel" class="tab-pane fade <?php if(isset($profile_id)): ?> <?php if($profile_id == 'billing'): ?> in active <?php endif; ?> <?php endif; ?>" id="billing">

						<div class="row m-0 border-bot">
							<h3 class="dashboard-sub-tit"><?php echo e(tr('billing')); ?></h3>
						</div>

						<div class="row p-t-20 m-t-5 set-payment border-bot">

							<div class="col-md-12">

							    <h4><?php echo e(tr('set_default_payment_mode')); ?></h4>

							    <p>Note: For payment mode update, just click on the payment mode. [ <?php echo e(tr('cod')); ?> / <?php echo e(tr('card')); ?>] </p>

							    <div class="btn-group" data-toggle="buttons">

							    	 <?php if(Setting::get('cod')): ?>

								        <label id="payment_mode_cod" class="btn btn-default <?php if(Auth::user()->payment_mode == 'cod'): ?> active <?php endif; ?>">
								            <input type="radio" name="payment_mode" value="cod"><?php echo e(tr('cod')); ?>

								        </label>

							        <?php endif; ?>

							         <?php if(Setting::get('card') == 1): ?>

								        <label id="payment_mode_card" class="btn btn-default <?php if(Auth::user()->payment_mode == 'card'): ?> active <?php endif; ?>">
								            <input type="radio" name="payment_mode" value="card"><?php echo e(tr('card')); ?>

								        </label>

							        <?php endif; ?>

							    </div>

							</div>

						</div>

						<span class="border-bot"></span>
						
						<div class="billing-sec dashboard-tab-sec row p-t-20">

							<div class="col-md-12">

								<h4 class=""><?php echo e(tr('add_card')); ?></h4>
								
								<span class="heading-underline"></span>

								<?php if(Setting::get('card') == 1): ?>

									<div class="row">
                    			
		                    			<div class="col-xs-12 col-sm-8 col-md-5 col-lg-5">
		                    				
		                    				<div class="card-wrapper row">

						            			<div class="jp-card-container jp-card-container1">

							            			<div class="jp-card jp-card-visa jp-card-identified  top">

								            			<div class="jp-card-front">

									            			<div class="jp-card-logo jp-card-visa">

									            				<?php echo e(tr('visa')); ?>


									            			</div>

								            				<div class="jp-card-lower">

								            					<div class="jp-card-shiny"></div>

									            				<div class="jp-card-cvc jp-card-display">•••</div>

									            				<div class="jp-card-number jp-card-display jp-card-invalid">XXXX XXXX XXXX XXXX</div>

									            				<div class="jp-card-name jp-card-display"><?php echo e(Auth::user()->name); ?></div>

									            				<div class="jp-card-expiry jp-card-display" data-before="month/year" data-after="validthru"><span id="jp-month">••</span>/<span id="jp-year">••</span></div>

															</div>

														</div>

													</div>

													<div class="jp-card jp-card-visa jp-card-identified jp-card-flipped col-lg-12 col-md-12 col-sm-12 col-xs-12 top">

														<div class="jp-card-back">

															<div class="jp-card-bar"></div>

															<div class="jp-card-cvc jp-card-display">•••</div>

															<div class="jp-card-shiny"></div>

														</div>

													</div>

												</div>

											</div>

		                    			</div>
		                    			
		                    			<div class="col-xs-12 col-sm-4 col-sm-offset-1 col-md-offset-1 col-md-5 col-lg-5 p-t-20">
		                    				
		                    				<form action="<?php echo e(route('user.cards.add')); ?>" method="POST" id="payment-form" class="form-horizontal card">

										        <div class="row" id="card-payment">

									                <input id="id" name="id" type="hidden" required>

									                <div class="form-group">

									                    <input id="name" name="number" type="text" placeholder="<?php echo e(tr('card_number')); ?>"  title="<?php echo e(tr('card_number_notes')); ?>" class="form-control" required pattern="[0-9]{16,}" data-stripe="number" 
									                    onkeyup="card_number_onkey(this.value)"  maxlength="16">   

									                </div>

									                <div class="form-group">
									                    <input id="email" name="cvv" type="text" placeholder="<?php echo e(tr('cvv')); ?>" required="" class="form-control input-md" data-stripe="cvc" onkeyup="$('.jp-card-cvc').html(this.value)" maxlength="4" minlength="3" pattern="[0-9]{3,}">
									                </div>

									                <div class="form-group">
									                    <input id="nationality" name="month" type="text"  required placeholder="<?php echo e(tr('mm')); ?>" class="form-control" autocomplete="cc-exp" data-stripe="exp-month" onkeyup="$('#jp-month').html(this.value)" maxlength="2" pattern="[0-9]{2,}">
									                </div>

									                <div class="form-group">
									                    <input id="language" name="year" data-stripe="exp-year"
									                    autocomplete="cc-exp" type="text" placeholder="<?php echo e(tr('yy')); ?>" class="form-control" required onkeyup="$('#jp-year').html(this.value)" maxlength="2" pattern="[0-9]{2,}">
									                </div>

									                <div class="col-md-12">

									                	<center><button type="submit" class="save-btn form-btn"><?php echo e(tr('submit')); ?></button></center>

									                </div>

									                <div class="clearfix"></div>

									                <div class="payment-errors text-danger col-lg-12"></div>

									                <br>

										        </div>

									        </form>
		                    			
		                    			</div>

		                    		</div>

								<?php endif; ?>

							</div>

						</div>
						<br>
						<?php if(count(Auth::user()->userCards) > 0): ?>
						
						<div class="row m-t-5 set-payment">

							<center><h4 class="p-t-20">List Cards</h4><span class="heading-underline"></span></center>

							<table class="table">
							    <thead class="thead-inverse">
									<tr>
										<th><?php echo e(tr('last_four')); ?></th>
										<th><?php echo e(tr('card_type')); ?></th>
										<th><?php echo e(tr('action')); ?></th>
									</tr>
							    </thead>

						    	<tbody>

					    			<?php foreach(Auth::user()->userCards as $c => $card): ?>

								      	<tr>
									        <td><?php echo e($card->last_four); ?></td>
									        <td><?php echo e($card->card_type); ?></td>
									        <td>
									        	<?php if($card->is_default): ?>

									        		<a href="<?php echo e(route('user.cards.default' , ['card_id' => $card->id])); ?>" class="btn btn-danger"><i class="fa fa-times"></i></a> 

									        	<?php else: ?>
									        		<a href="<?php echo e(route('user.cards.default' , ['card_id' => $card->id])); ?>" class="btn btn-success"><i class="fa fa-check"></i></a> 

									        	<?php endif; ?>

									        	<a href="<?php echo e(route('user.cards.delete' , ['card_id' => $card->id])); ?>" class="btn btn-success"><i class="fa fa-trash"></i></a> 

									        </td>
								      	</tr>

							      	<?php endforeach; ?>
							      	
						    	</tbody>
						  	
						  	</table>

						</div>

					  	<?php endif; ?>

					</div>
					<!-- End of billing tab -->

					<!-- FAV PROVIDERS tab -->
					<div role="tabpanel" class="tab-pane fade <?php if(isset($profile_id)): ?> <?php if($profile_id == 'fav_providers'): ?> in active <?php endif; ?> <?php endif; ?>" id="fav_providers">

						<div class="row m-0 border-bot">
							<h3 class="dashboard-sub-tit"><?php echo e(tr('fav_providers')); ?></h3>
						</div>

						<div class="row p-t-20 m-t-5 set-payment">

							<?php if(count($fav_providers) > 0): ?>

								<!-- Panel block -->
								<?php foreach($fav_providers as $key => $fav_provider): ?>

									<?php $provider_details = provider_details($fav_provider->provider_id); ?>

									 <?php if(count($provider_details) > 0): ?>
										<div class="col-md-4">

											<div class="fav-provider-card">

											    <a href="<?php echo e(route('user.tasker.profile' , ['provider_id' => $provider_details->unique_id ])); ?>">
											    	<img src="<?php echo e($provider_details->picture ? $provider_details->picture : asset('placeholder.png')); ?>" alt="<?php echo e($provider_details->name); ?>" class="img img-responsive img-thumbnail">
											    </a>

											    <h3><?php echo e($provider_details->name); ?></h3>

											    <p class="fav-provider-title"><?php echo e(count($provider_details->completed)); ?> <?php echo e(tr('completed_jobs')); ?> jobs</p>

											    <!-- <p><?php echo e($provider_details->email); ?></p> -->
											    
											    <p><a href="<?php echo e(route('user.user_fav_providers_remove' , ['user_fav_provider_id' => $provider_details->id ])); ?>"><button class="fav-provider-button">Remove</button></a></p>
											</div>

										</div>
									<?php endif; ?>

						       	<?php endforeach; ?>


						    <?php else: ?>

						    	<div class="col-md-12">

						    		<p><?php echo e(tr('no_result_found')); ?></p>

						    	</div>

					        <?php endif; ?>


						</div>


					</div>
					<!-- End of FAV PROVIDERS tab -->

					<!-- Change-pwd tab -->
					
					<div role="tabpanel" class="tab-pane fade <?php if(isset($profile_id)): ?> <?php if($profile_id == 'change_password'): ?>in active  <?php endif; ?> <?php endif; ?>" id="change_password">

						<div class="row m-0 border-bot">
							<h3 class="dashboard-sub-tit"><?php echo e(tr('change_password')); ?></h3>
						</div>

						<div class="change-pwd-sec dashboard-tab-sec row">

							<form class="billing-form p-f-30" action="<?php echo e(route('user.profile.change.password')); ?>" method="POST" role="form">

								<p class="delete-acc-txt text-muted">Note: <?php echo e(tr('change_password_content')); ?></p>

								<div class="form-group<?php echo e($errors->has('old_password') ? ' has-error' : ''); ?>">

									<label><?php echo e(tr('old_password')); ?> *</label>

									<input type="password" required name="old_password" class="form-control" data-trigger="hover" data-original-title="<?php echo e(tr('delete_account_password')); ?>" placeholder="<?php echo e(tr('old_password')); ?> ">

									<?php if($errors->has('old_password')): ?>
	                                    <span class="help-block">
	                                        <strong><?php echo e($errors->first('old_password')); ?></strong>
	                                    </span>
	                                <?php endif; ?>

								</div>

								<div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>"">

									<label><?php echo e(tr('new_password')); ?> *</label>

									<input type="password" required name="password" class="form-control" placeholder="<?php echo e(tr('new_password')); ?>" data-trigger="hover" data-original-title="Enter <?php echo e(tr('new_password')); ?> here">

									<?php if($errors->has('password')): ?>
	                                    <span class="help-block">
	                                        <strong><?php echo e($errors->first('password')); ?></strong>
	                                    </span>
	                                <?php endif; ?>
								</div>
								<div class="form-group<?php echo e($errors->has('password_confirmation') ? ' has-error' : ''); ?>"">

									<label><?php echo e(tr('confirm_password')); ?> *</label>
									<input type="password" required name="password_confirmation" class="form-control" placeholder="<?php echo e(tr('password_confirmation')); ?>" data-trigger="hover" data-original-title="<?php echo e(tr('password_confirmation')); ?>">

									<?php if($errors->has('password_confirmation')): ?>
	                                    <span class="help-block">
	                                        <strong><?php echo e($errors->first('password_confirmation')); ?></strong>
	                                    </span>
	                                <?php endif; ?>
								</div>
								<div>
									<button type="reset" class="cancel-btn form-btn"><?php echo e(tr('cancel')); ?></button>
									
									<button type="submit" onclick="return confirm(&quot;<?php echo e(tr('are_you_sure')); ?>&quot;);" class="save-btn form-btn"><?php echo e(tr('save')); ?></button>
								</div>
							</form>

						</div>							
					
					</div>
					<!-- End of Change-pwd tab -->

					<!-- Delete account tab -->
					<div role="tabpanel" class="tab-pane fade <?php if(isset($profile_id)): ?> <?php if($profile_id == 'delete_account'): ?> in active  <?php endif; ?> <?php endif; ?>" id="delete_account">
						<div class="row m-0 border-bot">
							<h3 class="dashboard-sub-tit"><?php echo e(tr('delete_account_note')); ?></h3>								
						</div>
						<div class="delete-acc-sec dashboard-tab-sec row p-30">

							<div class="col-md-12">

								<p class="delete-acc-txt"><?php echo e(tr('delete_account_content')); ?></p>

								<form class="" action="<?php echo e(route('user.delete.account')); ?>" method="POST" role="form">

									<?php if(Auth::user()->login_by == "manual"): ?>

										<div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">

											<label><?php echo e(tr('password')); ?> *</label>

											<input type="password" required name="password" class="form-control" data-trigger="hover" data-original-title="<?php echo e(tr(
											'delete_account_password')); ?>" placeholder="<?php echo e(tr('delete_account_password')); ?>">

											<?php if($errors->has('password')): ?>
			                                    <span class="help-block">
			                                        <strong><?php echo e($errors->first('password')); ?></strong>
			                                    </span>
			                                <?php endif; ?>

										</div>

									<?php endif; ?>

									<div>
										<button type="submit" onclick="return confirm(&apos;<?php echo e(tr('delete_account_confirm')); ?>&apos;)" class="save-btn form-btn"><?php echo e(tr('delete_account')); ?></button>
									</div>

								</form>
							</div>
						</div>
					
					</div>
					<!-- End of Delete account tab -->
				</div>
				
			</div>
			<!-- End of dashboard right -->
		
		</div>
	
	</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>

<script>

	$(document).ready(function() {

		var id = "<?php echo e(Auth::user()->id); ?>";
		
		var token = "<?php echo e(Auth::user()->token); ?>";
		
	    $('input[type=radio][name=payment_mode]').change(function() {

	    	var payment_mode = this.value;

	    	$.ajax({
	            'url' : '<?php echo e(url("/api/user/payment_mode_update")); ?>',
	            'data' : {id : id , token : token , payment_mode :payment_mode},
	            'type' : 'POST',
	            'success' : function(response) {

	             }
	        });
	    });

	    $('#delete_account').on('submit' , function() {

	    });
	});

</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/card/2.3.0/jquery.card.min.js"></script>

<script type="text/javascript" src="<?php echo e(asset('assets/js/card.js')); ?>"></script>

<script>
   
    $('#card-payment form').card({ container: $('.card-wrapper')});

    function card_number_onkey(value) {

    	$('.jp-card-number').html(value.replace(/\W/gi, '').replace(/(.{4})/g, '$1 '));
    	
    }

</script>

<script type="text/javascript" src="https://js.stripe.com/v2/"></script>

<script type="text/javascript">
    // This identifies your website in the createToken call below
    Stripe.setPublishableKey('<?php echo e(Setting::get("stripe_publishable_key", "pk_test_AHFoxSxndSb5RjlwHpfceeYa")); ?>');
    
    var stripeResponseHandler = function (status, response) {
        var $form = $('#payment-form');

        console.log(response);

        if (response.error) {
            // Show the errors on the form
            $form.find('.payment-errors').text(response.error.message);
            $form.find('button').prop('disabled', false);
            alert(response.error.message);

        } else {
            // token contains id, last4, and card type
            var token = response.id;
            
            // Insert the token into the form so it gets submitted to the server
            $form.append($('<input type="hidden" id="stripeToken" name="stripeToken" />').val(token));
             // alert(token);
            // and re-submit

            jQuery($form.get(0)).submit();

        }
    
    };

    $('#payment-form').submit(function (e) {
        
        if ($('#stripeToken').length == 0)
        {
            var $form = $(this);
            // Disable the submit button to prevent repeated clicks
            $form.find('button').prop('disabled', true);
            console.log($form);
            Stripe.card.createToken($form, stripeResponseHandler);

            // Prevent the form from submitting with the default action
            return false;
        }
    
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>