<div role="tabpanel" class="tab-pane fade <?php if(isset($profile_active)): ?> <?php if($profile_active == 'document'): ?> in active <?php endif; ?> <?php endif; ?>" id="document">
	<div class="row m-0 border-bot">
		<h3 class="dashboard-sub-tit"><?php echo e(tr('documents')); ?></h3>
	</div>

	<div class="billing-sec dashboard-tab-sec row">

		<form class="billing-form p-f-30" method="post" action="<?php echo e(route('provider.documents.upload')); ?>" enctype='multipart/form-data'>

			<?php if(count($documents = get_document_types()) > 0): ?>

				<?php foreach($documents as $d => $document): ?>

					<div class="form-group">

					    <label for="document"><?php echo e($document->name); ?></label>

					    <br>

					    <?php if($provider_document = get_provider_document($document->id , Auth::guard('provider')->user()->id)): ?>

							<input type="hidden" name="document_url_<?php echo e($document->id); ?>">

							<span class="pull-left">

							<a class="btn btn-success" href="<?php echo e($provider_document->document_url); ?>" target="_blank" style="margin-right: 5px;">

								<?php echo e(tr('view')); ?>


							</a>

							</span>

							<?php if(!Auth::guard('provider')->user()->is_approved): ?>

								<span class="">

									<a class="btn btn-danger" onclick="return confirm('Are You Sure?');" href="<?php echo e(route('provider.documents.delete' , $provider_document->id)); ?>">
										<i class="fa fa-times"></i>
									</a>
									
								</span>

							<?php endif; ?>

							<br>
							
							<br>

						<?php endif; ?>

					   	<input type="file" onchange="check_document_upload()" id="documents-data-<?php echo e($document->id); ?>" accept="image/png,image/gif,image/jpeg,application/pdf,text/csv" name="<?php echo e($document->id); ?>" class="">
					
					</div>

				<?php endforeach; ?>

				<div id="documents-data-error"></div>

				<div>
					<!-- <button class="cancel-btn form-btn">Cancel</button> -->
					<button type="submit" class="save-btn form-btn"><?php echo e(tr('submit')); ?></button>
				</div>

			<?php else: ?> 

				<p class="p-20"><?php echo e(tr('no_result_found')); ?></p>

			<?php endif; ?>
		
		</form>
	</div>
</div>