<?php $__env->startSection('title', tr('redeems')); ?>

<?php $__env->startSection('content-header', tr('redeems')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li><a href="<?php echo e(route('admin.providers.index')); ?>"><i class="fa fa-user"></i> <?php echo e(tr('providers')); ?></a></li>
    <li class="active"><i class="fa fa-user"></i> <?php echo e(tr('redeems')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">

        <div class="col-xs-12">

          	<div class="box box-success">

            	<div class="box-header with-border admin-panel-success">

	                <b style="font-size:18px;"><?php echo e(tr('redeems')); ?></b>

	                <a href="<?php echo e(route('admin.providers.index')); ?>" class="btn btn-warning pull-right"><?php echo e(tr('view_providers')); ?></a>
	                
	            </div>
            	
            	<div class="box-body">

					<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      <th><?php echo e(tr('id')); ?></th>
						      <th><?php echo e(tr('provider_name')); ?></th>
						      <th><?php echo e(tr('redeem_amount')); ?></th>
						      <th><?php echo e(tr('paid_amount')); ?></th>
						      <th><?php echo e(tr('sent_date')); ?></th>
						      <th><?php echo e(tr('status')); ?></th>
						      <th><?php echo e(tr('action')); ?></th>
						    </tr>
						
						</thead>

						<tbody>

							<?php foreach($redeems_requests as $i => $redeem_request_details): ?>

							    <tr>

							      	<td><?php echo e(showEntries($_GET,$i+1)); ?></td>

							      	<td>

							      		<a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $redeem_request_details->provider_id])); ?>">
							      			<?php echo e($redeem_request_details->provider ? $redeem_request_details->provider->name : ""); ?>

							      		</a>

							      	</td>

							      	<td><b><?php echo e(Setting::get('currency')); ?><?php echo e($redeem_request_details->request_amount); ?></b></td>

							      	<td><b><?php echo e(Setting::get('currency')); ?><?php echo e($redeem_request_details->paid_amount); ?></b></td>

							      	<td><?php echo e($redeem_request_details->created_at ? $redeem_request_details->created_at->diffForHumans() : ""); ?></td>

							      	<td><b><?php echo e(redeem_request_status($redeem_request_details->status)); ?></b></td>
							 
							      	<td>

							      		<?php if(in_array($redeem_request_details->status ,[REDEEM_REQUEST_SENT , REDEEM_REQUEST_PROCESSING])): ?>

								      		<form action="<?php echo e(route('admin.providers.payout.invoice')); ?>" method="POST">

								      			<input type="hidden" name="redeem_request_id" value="<?php echo e($redeem_request_details->id); ?>">

								      			<input type="hidden" name="paid_amount" value="<?php echo e($redeem_request_details->request_amount); ?>">

								      			<input type="hidden" name="provider_id" value="<?php echo e($redeem_request_details->provider_id); ?>">

								      			<button type="submit" class="btn btn-success btn-sm"><?php echo e(tr('paynow')); ?></button>
								      			
								      		</form>

								      	<?php else: ?>
								      		<span>-</span>
							      		<?php endif; ?>

							      	</td>

							    </tr>

							<?php endforeach; ?>
						
						</tbody>

					</table>

					<div align="right"><?php echo e($redeems_requests->links()); ?></div>

				</div>

			</div>

		</div>

	</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>