<?php $__env->startSection('breadcrumb'); ?>

    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    
    <li ><a href="<?php echo e(request()->headers->get('referer')); ?>"><i class="fa fa-diamond"></i> <?php echo e(tr('requests')); ?></a></li>
    
    <li class="active"><i class="fa fa-eye"></i> <?php echo e(tr('view_request')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title', tr('view_request')); ?>

<?php $__env->startSection('content-header', tr('view_request')); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<div class="box box-success">

    <div class="box-header with-border admin-panel-success">

        <h4 style="word-wrap: break-word;">
        	<b><?php echo e($request_details->name); ?></b>
        </h4>

	</div>

    <div class="box-body">
       
        <div class="col-md-12">

            <div class="row">

            	<?php if($request_details->description): ?>

		            <div class="col-md-12">

		            	<div style="box-shadow: 0px 0px 1px 1px #e0e0e0fa;word-wrap: break-word;">

		            		<p style="padding: 10px">

		            			<span class="text-uppercase" style="font-size: 16px"><b><?php echo e(tr('description')); ?>:</b></span>

		            			<br>

		            			<span class="rv-desc"><?php echo e($request_details->description); ?> </span>
		            		</p>

		            	</div>

		            	<br>
		            	
		            </div>

	            <?php endif; ?>

	            <div class="clearfix"></div> 

	            <div class="col-md-12">

	            	<table style="margin-bottom: 5px">
	            		<tr>
					        <td><?php echo e(tr('address')); ?></td>
					        <td><?php echo e($request_details->s_address ? $request_details->s_address : '-'); ?></td>
					    </tr>
	            	</table>

	           	</div>   

	            <div class="clearfix"></div> 

	            <div class="col-md-6">

	            	<table>
					    
					    <tr>
					        <td><?php echo e(tr('user')); ?></td>
					        <td><?php echo e($request_details->user ? $request_details->user->name : ""); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('provider')); ?></td>
					        <td> 
					        	<?php echo e($request_details->provider ? $request_details->provider->name : "-"); ?> 
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('job_type')); ?></td>
					        <td><?php echo e(job_type($request_details->job_type)); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('request_type')); ?></td>
					        <td><?php echo e(request_type($request_details->request_type)); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('category')); ?></td>
					        <td><?php echo e($request_details->category ? $request_details->category->name : "-"); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('sub_category')); ?></td>
					        <td><?php echo e($request_details->subCategory ? $request_details->subCategory->name : "-"); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('request_date')); ?></td>
					        <td>
					        	<?php if($request_details->request_date != "0000-00-00 00:00:00"): ?> 
		                    		<?php echo e(common_date($request_details->request_date , Auth::guard('admin')->user()->timezone)); ?> 
		                    	<?php endif; ?>
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('total_time')); ?></td>
					        <td>
					        	<?php echo e($request_payment_details->total_time); ?>

					        </td>
					    </tr>

	                    <tr>
					        <td><?php echo e(tr('start_time')); ?></td>
					        <td>
					        	<?php if($request_details->start_time != "0000-00-00 00:00:00"): ?> 
	                    			<?php echo e(common_date($request_details->start_time , Auth::guard('admin')->user()->timezone)); ?>  
	                    		<?php else: ?> 
	                    			- 
	                    		<?php endif; ?>
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('end_time')); ?></td>
					        <td>
					        	<?php if($request_details->end_time != "0000-00-00 00:00:00"): ?> 
	                    			<?php echo e(common_date($request_details->end_time , Auth::guard('admin')->user()->timezone)); ?>  
	                    		<?php else: ?> 
	                    			- 
	                    		<?php endif; ?>
					        </td>


					    </tr>

					    <tr>
					        <td><?php echo e(tr('is_abused_provider')); ?></td>
					        <td>
					        	<?php if($request_details->is_abused_provider == YES): ?> 
	                    			<?php echo e(tr('yes')); ?> 
	                    		<?php else: ?> 
	                    			<?php echo e(tr('no')); ?>

	                    		<?php endif; ?>
					        </td>

					    </tr>

					    <tr>
					        <td><?php echo e(tr('is_fav_provider')); ?></td>
					        <td>
					        	<?php if($request_details->is_fav_provider == YES): ?> 
	                    			<?php echo e(tr('yes')); ?> 
	                    		<?php else: ?> 
	                    			<?php echo e(tr('no')); ?>

	                    		<?php endif; ?>
					        </td>


					    </tr>

					    <?php if($request_details->cancelled_by): ?>

			                <tr>

			                	<td><?php echo e(tr('cancelled_by')); ?></td>
			                	<td><?php echo e($request_details->cancelled_by); ?></td>
			                	
			                </tr>

			                <tr>

			                	<td><?php echo e(tr('cancelled_date')); ?></td>
			                	<td><?php echo e(common_date($request_details->cancelled_date)); ?></td>
			                	
			                </tr>

			                <tr>

			                	<td><?php echo e(tr('cancelled_reason')); ?></td>
			                	<td><?php echo e($request_details->cancelled_reason); ?></td>
			                	
			                </tr>

		                <?php endif; ?>

		                <tr>
		                	<td><?php echo e(tr('is_coupon_applied')); ?></td>

		                	<td>
		                		<?php if($request_payment_details->is_coupon_applied == COUPON_APPLIED): ?>

		                			<span class="label label-success"><?php echo e(tr('yes')); ?></span>

		                		<?php else: ?>

		                			<span class="label label-danger"><?php echo e(tr('no')); ?></span>

		                		<?php endif; ?>
		                	</td>
		                
		                </tr>

		                <tr>
		                	<td><?php echo e(tr('coupon_code')); ?></td>

		                	<td><?php echo e($request_payment_details->coupon_code); ?></td>
		                </tr>
					    
					</table>
	           
	            </div>

	            <div class="col-md-6">

	            	<table>

					    <tr>
					        <td><?php echo e(tr('price_type')); ?></td>
                    		<td><?php echo e(price_type($request_details->price_type)); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('price_per_hour')); ?></td>
                    		<td><?php echo e($request_details->currency); ?> <?php echo e($request_details->price_per_hour); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('time_price')); ?></td>
                    		<td><?php echo e($request_details->currency); ?> <?php echo e($request_payment_details->time_price); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('tax_price')); ?></td>
                    		<td><?php echo e($request_details->currency); ?> <?php echo e($request_payment_details->tax_price); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('actual_total')); ?></td>
                    		<td><?php echo e($request_details->currency); ?> <?php echo e($request_payment_details->actual_total); ?></td>
					    </tr>

		                <tr>
		                	<td><?php echo e(tr('coupon_amount')); ?></td>

		                	<td><?php echo e($request_details->currency); ?> <?php echo e($request_payment_details->coupon_amount); ?></td>
		                </tr>

					    <tr>
					        <td><?php echo e(tr('paid_amount')); ?></td>
                    		<td><?php echo e($request_details->currency); ?> <?php echo e($request_details->total); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('admin_commission')); ?></td>
                    		<td><?php echo e($request_details->currency); ?> <?php echo e($request_payment_details->admin_amount); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('provider_amount')); ?></td>
                    		<td><?php echo e($request_details->currency); ?> <?php echo e($request_payment_details->provider_amount); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('status')); ?></td>
                    		<td><?php echo e(request_status($request_details->status)); ?></td>
					    </tr>

					    <tr>

		                    <td><?php echo e(tr('provider_status')); ?> : </td>
		                    <td>

		                    	<?php if(!in_array($request_details->status, [REQUEST_NO_PROVIDER_AVAILABLE,REQUEST_TIME_EXCEED_CANCELLED,REQUEST_CANCELLED])): ?>

		                    		<?php echo e(provider_status($request_details->provider_status)); ?>


		                    	<?php else: ?>
		                    		-
		                    	<?php endif; ?>
		                    </td>

		                </tr>
		                
					</table>
	            
	            </div>

        	</div>
        
	        <?php if($request_details->before_image !=''): ?>

		        <div class="col-md-6">
		            <div class="row">
		              <div class="col-md-12">
		                <section class="widget bg-white post-comments">

		                    <div class="widget btn btn-success text-center" style="width:100%;"><strong><?php echo e(tr('before_service')); ?></strong></div>

	                        <div class="media">
	                            <img style="width:100%;" src="<?php echo e($request_details->before_image); ?>" alt="">
	                        </div>

		                </section>
		              </div>
		            </div>
		        
		        </div>

		        <div class="col-md-6">
		            <div class="row">
		              <div class="col-md-12">
		                <section class="widget bg-white post-comments">
		                    <div class="widget btn btn-success text-center" style="width:100%;"><strong><?php echo e(tr('after_service')); ?></strong></div>
		                        <div class="media">
		                            <img style="width:100%;" src="<?php echo e($request_details->after_image); ?>" alt="">
		                        </div>
		                </section>
		              </div>
		            </div>
		        
		        </div>

	        <?php endif; ?>

	        <div class="row">
	            <div class="col-xs-12">
	            	<br>
	            	<h4><?php echo e(tr('location')); ?></h4>
	                <div class="" id="map"></div>
	            </div>
	        
	        </div>

    	</div>

	</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>

<style>
	dt {
		padding: 4px !important; 
	}

	dd {
		padding: 4px !important;
	}

	table {
	    font-family: arial, sans-serif;
	    border-collapse: collapse;
	    width: 100%;
	}

	td, th {
	    border: 1px solid #dddddd;
	    text-align: left;
	    padding: 8px;
	}

	tr:nth-child(even) {
	    background-color: #28ae5217;
	}

	td:nth-child(odd) {
	    color:#0000008a;
	}

	.rv-desc {
		line-height: 1.6;
	    letter-spacing: 0.6px;
	    font-size: 14px;
	}

</style>

<style type="text/css">

    html, body {
        height: 100%;
        margin: 0;
        padding: 0;
    }

    #map {
        height: 100%;
        min-height: 400px; 
    }

</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

	<script>
	    var map;
    	
    	var serviceLocation = {lat: parseFloat("<?php echo e($request_details->s_latitude); ?>"), lng: parseFloat("<?php echo e($request_details->s_longitude); ?>")};
	    
	    function initMap() {
	        map = new google.maps.Map(document.getElementById('map'), {
	            center: serviceLocation,
	            zoom: 15
	        });

	        var marker = new google.maps.Marker({
	            map: map,
	            position: serviceLocation,
	            visible: true,
	            animation: google.maps.Animation.DROP,
	        });
	    }
	</script>

	<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(envfile('GOOGLE_API_KEY')); ?>&libraries=places&callback=initMap" async defer></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>