<?php $__env->startSection('title',tr('coupons')); ?>

<?php $__env->startSection('content-header',tr('coupons')); ?>

<?php $__env->startSection('breadcrumb'); ?>

	<li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
	<li class="active"><?php echo e(tr('coupons')); ?></li>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
	
	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	
	<div class="row">
		
		<div class="col-xs-12">
	       
	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
            		
					<b style="font-size: 18px;"><?php echo e(tr('coupons')); ?></b>

					<a href="<?php echo e(route('admin.coupons.create')); ?>" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> <?php echo e(tr('add_coupon')); ?></b>
	                </a>

				</div>

				<div class="box-body">

					<?php if(count($coupons) == 0): ?>

						<h3 class="no-result"><?php echo e(tr('coupon_result_not_found_error')); ?></h3>

					<?php else: ?>

						<table id = "datatable-withoutpagination" class="table table-bordered table-striped">
							
							<thead>
								<tr>
									<th><?php echo e(tr('id')); ?></th>
									<th><?php echo e(tr('title')); ?></th>
									<th><?php echo e(tr('coupon_code')); ?></th>
									<th><?php echo e(tr('amount_type')); ?></th>
									<th><?php echo e(tr('amount')); ?></th>
									<th><?php echo e(tr('expiry_date')); ?></th>
									<th><?php echo e(tr('status')); ?></th>
									<th><?php echo e(tr('action')); ?></th>
								</tr>
							</thead>

							<tbody>
							
								<?php foreach($coupons as $i=> $coupon_details): ?>

								<tr>
									<td><?php echo e(showEntries($_GET,$i+1)); ?></td>

									<td><a href="<?php echo e(route('admin.coupons.view',['coupon_id' => $coupon_details->id] )); ?>"><?php echo e($coupon_details->title); ?></a></td>

									<td><?php echo e($coupon_details->coupon_code); ?></td>

									<td>
										<?php if($coupon_details->amount_type == 0): ?>
											<span class="label label-primary"><?php echo e(tr('percentage')); ?></span>
										<?php else: ?>
											<span class="label label-primary"><?php echo e(tr('absolute')); ?></span>
										<?php endif; ?>
									</td>

									<td>
										<?php if($coupon_details->amount_type == PERCENTAGE): ?>

											<?php echo e($coupon_details->amount); ?> %

										<?php else: ?>

											<?php echo e(Setting::get('currency')); ?> <?php echo e($coupon_details->amount); ?> 
										<?php endif; ?>

									</td>

									<td>
								
										<?php echo e(common_date($coupon_details->expiry_date , Auth::guard('admin')->user()->timezone , "d M y")); ?>

										
									</td>

									<td>
										<?php if($coupon_details->status == COUPON_APPROVED): ?>
											<span class="label label-success"><?php echo e(tr('approved')); ?></span>
										<?php else: ?>
											<span class="label label-warning"><?php echo e(tr('declined')); ?></span>
										<?php endif; ?>
									</td>

									<td>

										<div class="dropdown <?php if($i < 2): ?> dropdown <?php else: ?> dropup <?php endif; ?>">
											
											<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
	            								
												<?php echo e(tr('action')); ?>

												<span class="caret"></span>
											</button>

											<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
												<li>
													<a href="<?php echo e(route('admin.coupons.view',['coupon_id' => $coupon_details->id] )); ?>">
														<b><?php echo e(tr('view')); ?></b>
													</a>
												</li>
												<?php if(Setting::get('admin_demo_control')): ?>

													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left;"><b><?php echo e(tr('edit')); ?></b></a>
													</li>
													
													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left;">
															<b><?php echo e(tr('delete')); ?></b>
														</a>
													</li>

													<li role="separator" class="divider"></li>

												<?php else: ?>

													<li>
														<a href="<?php echo e(route('admin.coupons.edit',['coupon_id' => $coupon_details->id] )); ?>">
														<b><?php echo e(tr('edit')); ?></b>
														</a>
													</li>
													
													<li>
														<a href="<?php echo e(route('admin.coupons.delete',['coupon_id' => $coupon_details->id])); ?>" onclick="return confirm(&quot;<?php echo e(tr('admin_coupon_delete_confirmation' , $coupon_details->title)); ?>&quot;)" >
															<b><?php echo e(tr('delete')); ?></b>
														</a>
													</li>

													<li role="separator" class="divider"></li>

												<?php endif; ?>
																							
												<li>
													<?php if($coupon_details->status == 0): ?>
														<a href="<?php echo e(route('admin.coupons.status',['coupon_id' => $coupon_details->id])); ?>">
															<b> <?php echo e(tr('approve')); ?> </b> 
														</a>
													<?php else: ?>
														<a href="<?php echo e(route('admin.coupons.status',['coupon_id' => $coupon_details->id])); ?>" onclick="return confirm(&quot;<?php echo e($coupon_details->title); ?> - <?php echo e(tr('coupon_decline_confirmation')); ?>&quot;);">
															<b> <?php echo e(tr('decline')); ?> </b> </a>
														</a>
													<?php endif; ?>
												</li>

											</ul>

										</div>

									</td>

								</tr>

								<?php endforeach; ?>

							</tbody>
						
						</table>
						
						<div align="right"><?php echo e($coupons->links()); ?></div>	

					<?php endif; ?>

				</div>

			</div>

		</div>

	</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>