<?php $__env->startSection('title', tr('provider_subscriptions')); ?>

<?php $__env->startSection('content-header', tr('provider_subscriptions')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
     <li><a href="<?php echo e(route('admin.providers.index')); ?>"><i class="fa fa-users"></i> <?php echo e(tr('providers')); ?></a></li>
    <li class="active"><a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $provider_id] )); ?>"><i class="fa fa-user"></i> <?php echo e(tr('view_provider')); ?></a></li>
    
    <li class="active"><i class="fa fa-key"></i> <?php echo e(tr('provider_subscriptions')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>

<style>

.subscription-image {
	overflow: hidden !important;
	position: relative !important;
	height: 15em !important;
	background-position: center !important;
	background-repeat: no-repeat !important;
	background-size: cover !important;
	margin: 0 !important;
	width: 100%;
}

.subscription-desc {
	min-height: 10em !important;
	max-height: 10em !important;
	overflow: scroll !important;
	margin-bottom: 10px !important;
}

</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
	
	<div class="row">
			
        <div class="col-xs-12">
			
			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

          	<div class="box">

	            <div class="box-body table-responsive">

	            	<?php if(count($payments) > 0): ?>

		              	<table id="example1" class="table table-bordered table-striped">

							<thead>
							    <tr>
							      <th><?php echo e(tr('id')); ?></th>
							      <th><?php echo e(tr('name')); ?></th>
							      <th><?php echo e(tr('provider_subscription')); ?></th>
							      <th><?php echo e(tr('payment_id')); ?></th>
							      <th><?php echo e(tr('amount')); ?></th>
							      <th><?php echo e(tr('expiry_date')); ?></th>
							      <th style="display: none"><?php echo e(tr('reason')); ?></th>
							      <th style="display: none"><?php echo e(tr('action')); ?></th>
							    </tr>
							</thead>

							<tbody>

								<?php foreach($payments as $i => $payment_details): ?>

								    <tr>
								      	<td><?php echo e($i+1); ?></td>

								      	<td><a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $payment_details->provider_id] )); ?>"> <?php echo e(($payment_details->provider) ? $payment_details->provider->name : ''); ?> </a></td>

								      	<td>
								      		<?php if($payment_details->prividersubscription): ?>		
								      			<a href="<?php echo e(route('admin.provider_subscriptions.view' , ['provider_subscription_id' => $payment_details->prividersubscription->id] )); ?>" target="_blank"><?php echo e($payment_details->prividersubscription ? $payment_details->prividerSubscription->title : ''); ?></a>
								      		<?php endif; ?>
								      	</td>

								      	<td><?php echo e($payment_details->payment_id); ?></td>

								      	<td><?php echo e(Setting::get('currency')); ?> <?php echo e($payment_details->amount); ?></td>

								      	<td><?php echo e(date('d M Y',strtotime($payment_details->expiry_date))); ?></td>

								      	<td style="display: none"><?php echo e($payment_details->cancelled_reason); ?></td>

								      	<td class="text-center" style="display :none">

								      		<?php if($i == 0 && !$payment_details->is_cancelled && $payment_details->status == PAID_STATUS): ?> 
								      		<a data-toggle="modal" data-target="#<?php echo e($payment_details->id); ?>_cancel_subscription" class="pull-right btn btn-sm btn-danger"><?php echo e(tr('cancel_subscription')); ?></a>

								      		<?php elseif($i == 0 && $payment_details->is_cancelled && $payment_details->status == PAID_STATUS): ?>

							      				<?php $enable_subscription_notes = tr('enable_subscription_notes') ; ?>
							      			
							      				<a onclick="return confirm('<?php echo e($enable_subscription_notes); ?>')" href="<?php echo e(route('admin.providers.subscriptions.enable', ['provider_id' => $payment_details->provider_id])); ?>" class="pull-right btn btn-sm btn-success"><?php echo e(tr('enable_subscription')); ?></a>

							      			<?php else: ?>
							      				-		
								      		<?php endif; ?>
								      	</td>

								    </tr>

						            <div class="modal fade error-popup" id="<?php echo e($payment_details->id); ?>_cancel_subscription" role="dialog">

						                <div class="modal-dialog">

						                    <div class="modal-content">

						                   		<form method="post" action="<?php echo e(route('admin.providers.subscriptions.cancel', ['provider_id' => $payment_details->provider_id])); ?>">

							                        <div class="modal-body">

							                            <div class="media">

							                        		<div class="media-body">

							                                   <h4 class="media-heading"><?php echo e(tr('reason')); ?> *</h4>

							                                   <textarea rows="5" name="cancel_reason" id='cancel_reason' required style="width: 100%"></textarea>

							                               </div>

							                            </div>

							                            <div class="text-right">

							                           		<br>

							                               <button type="submit" class="btn btn-primary top"><?php echo e(tr('submit')); ?></button>

							                           </div>

							                        </div>

						                        </form>

						                    </div>

						                </div>

						            </div>

								<?php endforeach; ?>

							</tbody>

						</table>

						<div>
							
						</div>

					<?php else: ?>
						<h3 class="no-result"><?php echo e(tr('no_provider_subscription_found')); ?></h3>
					<?php endif; ?>

	            </div>

          	</div>

        </div>
    
    </div>

	<div class="row">

		<div class="col-md-12">

			<div class="row">

				<?php if(count($provider_subscriptions) > 0): ?>

					<?php foreach($provider_subscriptions as $s => $provider_subscription_details): ?>

						<div class="col-md-4 col-lg-4 col-sm-6 col-xs-12">

							<div class="thumbnail">

								<div class="caption">

									<h3>
										<a href="<?php echo e(route('admin.provider_subscriptions.view', ['provider_subscription_id' => $provider_subscription_details->id])); ?>" target="_blank"><?php echo e($provider_subscription_details->title); ?></a>
									</h3>

									<hr>


									<h4><b><?php echo e(tr('description')); ?> : </b></h4>

									<div class="subscription-desc">
										<?php echo $provider_subscription_details->description; ?>
									</div>

									<br>

									<p>
										<span class="btn btn-danger pull-left" style="cursor: default;"><?php echo e(Setting::get('currency')); ?> <?php echo e($provider_subscription_details->amount); ?> / <?php echo e($provider_subscription_details->plan); ?> M</span>

										<a href="<?php echo e(route('admin.providers.subscriptions.plans.save' , ['provider_subscription_id' => $provider_subscription_details->id, 'provider_id' => $provider_id])); ?>" class="btn btn-success pull-right"><?php echo e(tr('choose')); ?></a>
									</p>
									<br>
									<br>
								</div>
							
							</div>
						
						</div>

					<?php endforeach; ?>

				<?php endif; ?>
				
			</div>
		</div>
	
	</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>