<?php $__env->startSection('title', tr('request_payments')); ?>

<?php $__env->startSection('content-header',tr('request_payments')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-money"></i> <?php echo e(tr('request_payments')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">

        <div class="col-xs-12">

	        <div class="box box-success">

	            <div class="box-header with-border admin-panel-success">

	                <b><?php echo e(tr('request_payments')); ?></b>

	                <!-- EXPORT OPTION START -->

                    <?php if(count($request_payments) > 0 ): ?>
                    
                        <ul class="admin-action btn btn-warning pull-right" style="margin-right: 40px;">
                            
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                  <?php echo e(tr('export')); ?> <span class="caret"></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.payments.export' , ['format' => 'xlsx'])); ?>">
                                            <span class="text-red"><b><?php echo e(tr('excel_sheet')); ?></b></span>
                                        </a>
                                    </li>

                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.payments.export' , ['format' => 'csv'])); ?>">
                                            <span class="text-blue"><b><?php echo e(tr('csv')); ?></b></span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        
                        </ul>

                    <?php endif; ?>

                <!-- EXPORT OPTION END -->
	            </div>

	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
								<th><?php echo e(tr('id')); ?></th>
								<th><?php echo e(tr('request')); ?></th>
								<th><?php echo e(tr('payment_id')); ?></th>
								<th><?php echo e(tr('username')); ?></th>
								<th><?php echo e(tr('payment_mode')); ?></th>
								<th><?php echo e(tr('admin_commission')); ?></th>
								<th><?php echo e(tr('provider_amount')); ?></th>
								<th><?php echo e(tr('total')); ?></th>
								<th><?php echo e(tr('status')); ?></th>
						    </tr>
						</thead>

						<tbody>

							<?php if(count($request_payments) > 0): ?>

								<?php foreach($request_payments as $i => $request_payment_details): ?>

								    <tr>
								      	<td><?php echo e(showEntries($_GET,$i+1)); ?></td>

								      	<td>
								      		<?php if( $request_payment_details->requests): ?>
								      		
								      			<a href="<?php echo e(route('admin.requests.view' , ['request_unique_id' =>  $request_payment_details->requests->unique_id ] )); ?>"><?php echo e($request_payment_details->requests->name); ?>

								      			</a>

								      		<?php endif; ?>
								      	</td>
								      	
								      	<td><?php echo e($request_payment_details->payment_id); ?></td>

								      	<td><a href="<?php echo e(route('admin.users.view' ,[ 'user_id' =>  $request_payment_details->user_id ])); ?>"> <?php if( $request_payment_details->user): ?> <?php echo e($request_payment_details->user->name); ?> <?php endif; ?></a></td>

								      	<td><?php echo e($request_payment_details->payment_mode); ?> </td>

								      	<td>
								      		<?php if( $request_payment_details->requests): ?>
								      			 	<?php echo e($request_payment_details->requests->currency); ?>

								      			 	<?php echo e($request_payment_details->admin_amount ?  $request_payment_details->admin_amount : "0.00"); ?>

								      		<?php endif; ?>
								      	</td>
								      	<td>
								      		<?php if( $request_payment_details->requests): ?> <?php echo e($request_payment_details->requests->currency); ?><?php echo e($request_payment_details->provider_amount ?  $request_payment_details->provider_amount : "0.00"); ?>

								      		<?php endif; ?>
								      	</td>
								      	<td>
								      		<?php if( $request_payment_details->requests): ?> <?php echo e($request_payment_details->requests->currency); ?><?php echo e($request_payment_details->total ?  $request_payment_details->total : "0.00"); ?> 
								      		<?php endif; ?>
								      	</td>

								      	<td>
								      		<?php if( $request_payment_details->status): ?> 
								      			<span style="color: green;"><b><?php echo e(tr('paid')); ?></b></span>
								      		<?php else: ?>
								      			<span style="color: red"><b><?php echo e(tr('not_paid')); ?></b></span>
								      		<?php endif; ?>
								      	</td>
								    </tr>					

								<?php endforeach; ?>

							<?php endif; ?>

						</tbody>
					
					</table>
					<div align="right"><?php echo e($request_payments->links()); ?></div>
	            </div>

          	</div>
        </div>
    </div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>