<?php $__env->startSection('after-styles'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('common/css/grid-gallery.css')); ?>">

<style>

	.switch {
		position: relative;
		display: inline-block;
		width: 60px;
		height: 34px;
	}

	.switch input {display:none;}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 26px;
		width: 26px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
	}

	input:checked + .slider {
		background-color: #51af33;
	}

	input:focus + .slider {
		box-shadow: 0 0 1px #2196F3;
	}

	input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
	}

	/* Rounded sliders */
	.slider.round {
		border-radius: 34px;
	}

	.slider.round:before {
		border-radius: 50%;
	}

	.block{
        text-align: center;
        vertical-align: middle;
    }
    .circle{
        background: #51af33;
        border-radius: 50%;
        color: white;
        height: 150px;
        font-weight: bold;
        width: 150px;
    }
	.circle span{
		display: table-cell;
		padding-top:40%;
		font-size: 20px;
	}

	.card-button {
		margin-left: 4%;
		margin-top: 3%;

	}
	.redeem-image{
		background-position: center;
		background-size: cover;
		background-repeat: no-repeat;
		height: 200px;
		width: 200px;
		margin: 0 auto;
		display: flex;
		align-items: center;
		justify-content: center;
	}

</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30">
		
		<div class="container">

		    <?php if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING): ?>
		    
		        <div class="alert alert-danger text-uppercase">
		            <?php echo e(tr('provider_waiting_for_admin_approval')); ?>

		        </div>

		    <?php endif; ?>
			    
			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			<div class="dashboard-right-col col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-2 col-md-offset-2">   

				<div class="main">
				    
				    <div class="row">

				        <div class="<?php echo e(Auth::guard('provider')->user()->subscription_expired ? 'col-12 col-xs-9 col-sm-9 col-md-9 col-lg-9 sec-space3 col-lg-offset-2' : 'col-12 col-xs-12 col-sm-12 col-md-10 col-lg-10 sec-space2'); ?>">
				            <div class="section-side-spacing section-top-bottom-spacing">
				                <!-- <h3 class="m-0 top text-center"><?php echo e(tr('billing_info')); ?></h3> -->
				                <div class="panel panel-default top1">
				                    <div class="panel-heading theme-heading">
				                        <h4><?php echo e(tr('billing_info')); ?>

				                        <span class="pull-right hidden-xs"><img src="<?php echo e(asset('img/card-type.png')); ?>" class="card-img img-responsive"></span></h4>
				                        <div class="clear-both"></div>
				                    </div>
				                    <div class="panel-body">

				                        <form class="login-form" id="payment-form" method="POST" action="<?php echo e(route('provider.add.card')); ?>">

				                            <div class="row">

				                                <div class="col-xs-12 col-sm-6 col-md-12">

				                                    <div class="card-wrapper"></div>

				                                </div>

				                                <div class="col-xs-12 col-sm-12 col-md-12">

				                                    <div class="form-group">
				                                    
				                                        <label for="name"><?php echo e(tr('name')); ?></label>

				                                        <div class="input-group">

				                                            <input  type="text" id="name" name="card_name" required class="form-control" placeholder="<?php echo e(tr('name')); ?>" /><span class="input-group-addon"><i class="fa fa-user"></i></span>
				                                        </div>
				                                    
				                                    </div>
				                                    
				                                    <div class="form-group">

				                                        <label for="cardNumber"><?php echo e(tr('card_number')); ?></label>

				                                        <div class="input-group">

				                                            <input  type="tel" class="form-control" required name="number" placeholder="<?php echo e(tr('card_number')); ?>" autocomplete="cc-number"  autofocus  data-stripe="number" id="number" maxlength="19" onkeyup="card_number_onkey(this.value)" /><span class="input-group-addon"><i class="fa fa-credit-card"></i></span>
				                                        </div>

				                                    
				                                    </div>

				                                    <div class="form-group row">
				                                        
				                                        <div class="col-lg-6 col-md-8 col-xs-12 col-sm-12">

				                                            <label for="cardExpiry"><?php echo e(tr('expiry_date')); ?></label>

				                                            <div class="row">

				                                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">

				                                                    <input  type="tel"  class="form-control expiry" id="expiry_month"  name="expiry_month" placeholder="MM" autocomplete="cc-exp" required data-stripe="exp-month" maxlength="2" pattern="[0-9]{2,}"/>

				                                                </div>

				                                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">

				                                                    <input  type="tel"  class="form-control expiry" id="expiry_year"  name="expiry_year" placeholder="YY" autocomplete="cc-exp" required data-stripe="exp-year" maxlength="2" pattern="[0-9]{2,}"/>

				                                                </div>

				                                            </div>

				                                        </div>

				                                        <div class="col-lg-6 col-md-4 col-sm-12 col-xs-12">

				                                            <label for="cardCVC"><?php echo e(tr('cvv_number')); ?></label>

				                                            <input type="text" size="4" id="cvc" data-stripe="cvc" class="form-control" name="cvc" placeholder="<?php echo e(tr('cvv_number')); ?>" autocomplete="cc-csc" required maxlength="3" />

				                                        </div>
				                                   

				                                    </div>

				                                </div>

				                            </div>

				                            <div class="text-right">
				                                <a href="" class="btn btn-default"><?php echo e(tr('cancel')); ?></a>
				                                <button type="submit" class="btn btn-primary"><?php echo e(tr('save')); ?></button>
				                            </div>

				                        </form>

				                        <div class="clearfix"></div>

				                        <div class="top1">

				                        <?php if($cards->data): ?>

				                            <?php foreach($cards->data->cards as $key => $card): ?>

				                            <div class="media">

				                                <div class="media-left">
				                                    <img src="../img/credit-card.png" class="media-object1">
				                                </div>

				                                <div class="media-body">
				                                    <?php $delete = tr('are_your_sure'); ?>

				                                    <?php if(!$card->is_default): ?> 
				                                    <p class="m-0 pull-right">

				                                    <a href="<?php echo e(route('provider.delete.card', ['provider_card_id' => $card->provider_card_id])); ?>" title="<?php echo e(tr('delete')); ?>" onclick="return confirm(&quot;<?php echo e($delete); ?> &quot);" class="black-clr"><i class="fa fa-trash" style="color: black"></i></a>
				                                    </p>

				                                    <?php endif; ?>
				                                    
				                                    <h4 class="media-heading uppercase">xxxx xxxx xxxx <?php echo e($card->last_four); ?></h4>
				                                    
				                                    <?php if($card->is_default): ?>
				                                        <p class="captalize m-0"><a class="green" title="<?php echo e(tr('set_as_default')); ?>"><?php echo e(tr('default')); ?></a></p>
				                                    <?php else: ?>
				                                        <p class="captalize m-0"><a href="<?php echo e(route('provider.default.card', ['provider_card_id'=> $card->provider_card_id])); ?>" class="red" title="<?php echo e(tr('set_as_default')); ?>"><?php echo e(tr('set_as_default')); ?></a></p>
				                                    <?php endif; ?>

				                                </div>

				                            </div>

				                            <p class="grey-line"></p>

				                            <?php endforeach; ?>
				                        
				                        <?php endif; ?>

				                        </div>
				                    </div>
				                </div>
				            </div>
				        </div>
				    </div>

				</div>

			</div>

		</div>
	
	</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/card/2.3.0/jquery.card.min.js"></script>

<script type="text/javascript" src="<?php echo e(asset('js/card.js')); ?>"></script>

<script>
    new Card({
        form: document.querySelector('form'),
        container: '.card-wrapper',
        formSelectors: {
            // numberInput: 'input#number', // optional — default input[name="number"]
            expiryInput: 'input.expiry', // optional — default input[name="expiry"]
            // cvcInput: 'input#cvc', // optional — default input[name="cvc"]
            nameInput: 'input#name' // optional - defaults input[name="name"]
        },
    });

</script>

<script>

    function card_number_onkey(value) {

        $('#number').html(value.replace(/\W/gi, '').replace(/(.{4})/g, '$1 '));
                
    }

</script>

<script type="text/javascript" src="https://js.stripe.com/v2/"></script>

<script type="text/javascript">

    // This identifies your website in the createToken call below
    Stripe.setPublishableKey('<?php echo e(Setting::get("stripe_publishable_key")); ?>');
    
    var stripeResponseHandler = function (status, response) {

        var $form = $('#payment-form');

        console.log(response);

        if (response.error) {
            // Show the errors on the form
            // $form.find('.payment-errors').text(response.error.message);

            toastr.error(response.error.message);

            $form.find('button').prop('disabled', false);

            // alert(response.error.message);

        } else {
            // token contains id, last4, and card type
            var token = response.id;
            
            // Insert the token into the form so it gets submitted to the server
            $form.append($('<input type="hidden" id="stripeToken" name="stripeToken" />').val(token));
             // alert(token);
            // and re-submit

            jQuery($form.get(0)).submit();

        }
    
    };

    $('#payment-form').submit(function (e) {
        
        if ($('#stripeToken').length == 0) {

            var $form = $(this);
            // Disable the submit button to prevent repeated clicks
            $form.find('button').prop('disabled', true);

            console.log($form);

            Stripe.card.createToken($form, stripeResponseHandler);

            // Prevent the form from submitting with the default action
            return false;
        }
    
    });


</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.provider', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>