<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo e(Setting::get('site_name')); ?> | <?php echo $__env->yieldContent('title'); ?> </title>
    
    <meta name="robots" content="noindex">
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="<?php echo e(asset('admin-css/bootstrap/css/bootstrap.min.css')); ?>">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="<?php echo e(asset('admin-css/bootstrap/css/ionicons.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('admin-css/dist/css/AdminLTE.min.css')); ?>">
    <!-- iCheck -->
    <link rel="stylesheet" href="<?php echo e(asset('admin-css/plugins/iCheck/square/blue.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin-css/dist/css/custom.css')); ?>">

    <link rel="shortcut icon" href="<?php echo e(Setting::get('site_icon') ?: asset('favicon.png')); ?>">

</head>

<body class="hold-transition login-page">

    <div class="admin-bg-login">
    
        <div class="col-md-6 col-md-offset-3">

            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>

        <div class="login-box">

            <!-- <div class="login-logo" style="padding: 10px 0 10px 25%; background: #ececeb;margin-bottom: 0"> -->
            <div class="login-logo">
                 <a href="<?php echo e(route('admin.login')); ?>">
                    <b> 
                        <img class="adm-log-logo img-responsive" style="max-height: 100px !important;" src="<?php if(Setting::get('site_logo')): ?> <?php echo e(Setting::get('site_logo')); ?> <?php else: ?> <?php echo e(asset('logo.png')); ?> <?php endif; ?>" />

                    </b>
                </a>
            </div>

            <?php echo $__env->yieldContent('content'); ?>

        </div>
    </div>

    <!-- jQuery 2.2.0 -->
    <script src="<?php echo e(asset('admin-css/plugins/jQuery/jQuery-2.2.0.min.js')); ?>"></script>
    <!-- Bootstrap 3.3.6 -->
    <script src="<?php echo e(asset('admin-css/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <!-- iCheck -->
    <script src="<?php echo e(asset('admin-css/plugins/iCheck/icheck.min.js')); ?>"></script>

    <?php echo $__env->yieldContent('scripts'); ?>

    <script>
        $(function () {
            $('input').iCheck({
              checkboxClass: 'icheckbox_square-blue',
              radioClass: 'iradio_square-blue',
              increaseArea: '20%' // optional
            });
        });
    </script>

</body>

</html>

