<?php $__env->startSection('title', tr('bannerimages')); ?>

<?php $__env->startSection('content-header', tr('bannerimages')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-picture-o"></i> <?php echo e(tr('bannerimages')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">

        <div class="col-xs-12">

            <div class="box box-success">


                <div class="box-header with-border admin-panel-success">

                    <b><?php echo e(tr('bannerimages')); ?></b>

                    <a href="<?php echo e(route('admin.banners.create')); ?>" style="float:right" class="btn btn-warning">
                        <b><i class="fa fa-plus"></i> <?php echo e(tr('add_bannerimage')); ?></b>
                    </a>

                </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                              <th><?php echo e(tr('id')); ?></th>
                              <th><?php echo e(tr('banner_title')); ?></th>
                              <th><?php echo e(tr('banner_text')); ?></th>
                              <th><?php echo e(tr('image')); ?></th>
                              <th><?php echo e(tr('view')); ?></th>
                              <th><?php echo e(tr('status')); ?></th>
                              <th><?php echo e(tr('action')); ?></th>
                            </tr>
                        </thead>

                        <tbody>

                            <?php foreach($banners as $i => $banner_details): ?>
                    
                                <tr>
                                    <td><?php echo e(showEntries($_GET,$i+1)); ?></td>

                                    <td><?php echo e($banner_details->banner_title ? $banner_details->banner_title : "-"); ?></td>

                                    <td><?php echo e($banner_details->banner_text ? $banner_details->banner_text : "-"); ?></td>

                                    <td>
                                        <img style="height: 30px;" src="<?php echo e($banner_details->picture); ?>">
                                    </td>

                                    <td>
                                        <a href="<?php echo e($banner_details->picture); ?>" target="_blank">
                                            <span class="btn btn-info btn-large"><?php echo e(tr('view')); ?></span>
                                        </a>
                                    </td>

                                    <td>
                                        <?php if($banner_details->status == COMMON_APPROVED): ?>
                                            <span class="label label-success"><?php echo e(tr('approved')); ?></span>
                                        <?php else: ?>
                                            <span class="label label-warning"><?php echo e(tr('pending')); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        
                                        <div class="dropdown">
                                            
                                            <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <?php echo e(tr('action')); ?>

                                                <span class="caret"></span>
                                            </button>

                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                                
                                                <?php if(Setting::get('admin_demo_control')): ?>
                                                    
                                                    <li>
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('edit')); ?></b></a>
                                                    </li>
                                                    
                                                    <li>
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('delete')); ?></b></a>
                                                    </li>

                                                <?php else: ?>

                                                    <li>
                                                        <a href="<?php echo e(route('admin.banners.edit', ['banner_id' => $banner_details->id] )); ?>"><b><?php echo e(tr('edit')); ?></b></a>
                                                    </li>

                                                    <li>
                                                        <a onclick="return confirm(&quot;<?php echo e(tr('admin_bannerimage_delete_confirmation' , $banner_details->banner_title)); ?>&quot;)"  href="<?php echo e(route('admin.banners.delete',['banner_id' => $banner_details->id] )); ?>"><b><?php echo e(tr('delete')); ?></b></a>
                                                    </li>

                                                <?php endif; ?>
                                                    
                                                <li class="divider" role="presentation"></li>

                                                <li>

                                                    <?php if(Setting::get('admin_demo_control')): ?>
                                                        
                                                        <?php if($banner_details->status == COMMON_APPROVED): ?>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                                <b><?php echo e(tr('decline')); ?></b>
                                                            </a>

                                                        <?php else: ?>

                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                                <b><?php echo e(tr('approve')); ?></b>
                                                            </a>

                                                        <?php endif; ?>

                                                    <?php else: ?>

                                                        <?php if($banner_details->status == COMMON_APPROVED): ?>

                                                            <a onclick="return confirm(&quot;<?php echo e($banner_details->banner_title); ?> - <?php echo e(tr('bannerimage_decline_confirmation')); ?>&quot;);" href="<?php echo e(route('admin.banners.status',array('banner_id' => $banner_details->id))); ?>"><b><?php echo e(tr('decline')); ?></b></a>

                                                        <?php else: ?>

                                                            <a href="<?php echo e(route('admin.banners.status',array('banner_id' => $banner_details->id))); ?>"><b><?php echo e(tr('approve')); ?></b></a>

                                                        <?php endif; ?>

                                                    <?php endif; ?>

                                                </li>

                                            </ul>

                                        </div>
                                    
                                    </td>
                                
                                </tr>

                            <?php endforeach; ?>

                        </tbody>
                        
                    </table>

                    <div align="right"><?php echo e($banners->links()); ?></div>
                
                </div>

            </div>

        </div>
        
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>