<?php $__env->startSection('content'); ?>

<div class="main-content">

    <div class="task-choose bg-img" style="background-image: url(<?php echo e(asset('common/img/login-bg.jpg')); ?>);">

        <div class="task-choose-outer">

            <div class="task-choose-inner white-bg">

                <a class="task-logo" href="<?php echo e(route('home')); ?>">
                    <div class="bg-img logo" style="background-image: url(<?php echo e(Setting::get('site_logo')); ?>);"></div>
                </a>

                <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                <form class="login-form" role="form" method="POST" action="<?php echo e(route('provider.login.post')); ?>">

                    <input type="hidden" name="timezone" value="" id="userTimezone">

                    <div class="form-group <?php if($errors->has('email')): ?> has-error <?php endif; ?>">
                        <label><?php echo e(tr('email')); ?></label>
                        <input type="email" required class="form-control" name="email" value="<?php echo e(old('email') ? old('email'): Setting::get('demo_provider_email')); ?>" placeholder="<?php echo e(tr('enter_email')); ?>">
                       
                        <?php if($errors->has('email')): ?> <p class="help-block"><?php echo e($errors->first('email')); ?></p> <?php endif; ?>

                    </div>

                    <div class="form-group <?php if($errors->has('password')): ?> has-error <?php endif; ?>">
                        <label><?php echo e(tr('password')); ?></label>
                        <input type="password" required class="form-control" name="password" placeholder="<?php echo e(tr('enter_password')); ?>" value="<?php echo e(old('password') ? old('password'): Setting::get('demo_provider_password')); ?>">

                        <?php if($errors->has('password')): ?> <p class="help-block"><?php echo e($errors->first('password')); ?></p> <?php endif; ?>
                    </div>

                    <button type="submit" class="btn btn-primary sub-btn"><?php echo e(tr('submit')); ?></button>


                    <p class="login-txt btm-txt text-center">
                        <a href="<?php echo e(route('provider.password.reset')); ?>" class="forgot-link common-link"><?php echo e(tr('forgot_password')); ?></a>
                    </p>

                    <p class="login-txt btm-txt text-center"><?php echo e(tr('dont_have_account')); ?>

                        <a href="<?php echo e(route('provider.register.form')); ?>" class="common-link"><?php echo e(tr('signup')); ?></a>
                    </p>

                    <p class="login-txt btm-txt text-center"><?php echo e(tr('sign_up_agree')); ?>

                        <a href="<?php echo e(route('terms')); ?>" target="_blank"  class="common-link"><?php echo e(tr('terms')); ?></a> <?php echo e(tr('and')); ?> 
                        <a href="<?php echo e(route('privacy')); ?>"  target="_blank" class="common-link"><?php echo e(tr('privacy')); ?></a></p>
                </form>
            </div>
        
        </div>

    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>


<script src="<?php echo e(asset('common/js/jstz.min.js')); ?>"></script>
<script>
    
    $(document).ready(function() {

        var dMin = new Date().getTimezoneOffset();
        var dtz = -(dMin/60);
        // alert(dtz);
        $("#userTimezone").val(jstz.determine().name());
    });

    $('form').submit(function () {
        $(this).find(':submit').attr('disabled', 'disabled');
    });

    // $("form").bind("invalid-form.validate", function () {
    //     $(this).find(':submit').prop('disabled', false);
    // });

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.provider.focused', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>