<?php $__env->startSection('title', tr('fav_providers')); ?>

<?php $__env->startSection('content-header'); ?>

<?php echo e(tr('fav_providers')); ?> 

<?php if(count($user_details) > 0): ?>

- <a href="<?php echo e(route('admin.users.view' , ['user_id' => $user_details->id])); ?>"><?php echo e($user_details->name); ?></a>

<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>

    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>

    <?php if(count($user_details) > 0): ?>

	    <li> <a href="<?php echo e(route('admin.users.index')); ?>"><i class="fa fa-user"></i> <?php echo e(tr('users')); ?></a></li>

	    <li>
	    	<a href="<?php echo e(route('admin.users.view' , ['user_id' => $user_details->id])); ?>">
	    		<i class="fa fa-dashboard"></i>
	    		<?php echo e(tr('view_user')); ?>

	    	</a>
	    </li>

    <?php else: ?>

		<li> <a href="<?php echo e(route('admin.requests.bidding')); ?>"><i class="fa fa-diamond"></i> <?php echo e(tr('requests')); ?></a></li>

    <?php endif; ?>

    <li class="active"><i class="fa fa-star"></i> <?php echo e(tr('fav_providers')); ?></li>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">
		
        <div class="col-xs-12">

        	<div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
                
	                <b class="text-uppercase"><?php echo e(tr('fav_providers')); ?></b>

	                <?php if(count($user_details) > 0): ?>
	                
	                <a href="<?php echo e(route('admin.users.index')); ?>" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-eye"></i> <?php echo e(tr('view_users')); ?></b>
	                </a>

	                <?php endif; ?>
            	</div>
            
	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      	<th><?php echo e(tr('id')); ?></th>
						      	<th><?php echo e(tr('provider')); ?></th>
						      	<th><?php echo e(tr('email')); ?></th>
						      	<th><?php echo e(tr('mobile')); ?></th>
						      	<th><?php echo e(tr('request')); ?></th>
						      	<th><?php echo e(tr('date')); ?></th>
						      	<th><?php echo e(tr('action')); ?></th>
						    </tr>
						</thead>

						<tbody>

							<?php foreach($fav_providers as $i => $fav_provider_details): ?>
								
							    <tr>

							      	<td><?php echo e(showEntries($_GET,$i + 1)); ?></td>
							      	
									<td>
										<a href="<?php echo e(route('admin.providers.view' , ['provider_id' =>  $fav_provider_details->provider_id])); ?>" target="_blank" class="">
											<?php echo e($fav_provider_details->provider_name); ?>

										</a>
									</td>

									<td><?php echo e($fav_provider_details->provider_email); ?></td>

									<td><?php echo e($fav_provider_details->provider_mobile); ?></td>

									<td>
										<a href="<?php echo e(route('admin.requests.view' , ['request_unique_id' =>  $fav_provider_details->request_unique_id] )); ?>" target="_blank" class="">
											<?php echo e($fav_provider_details->request_name); ?>

										</a>
									</td>

									<td><?php echo e($fav_provider_details->created_at); ?></td>

									<td>
										<a href="<?php echo e(route('admin.users.fav_providers.remove' , ['user_fav_provider_id' => $fav_provider_details->user_fav_provider_id] )); ?>" class="btn btn-danger" onclick="return confirm(&quot;<?php echo e(tr('user_fav_provider_remove_confirmation')); ?>&quot; );">
											<?php echo e(tr('remove')); ?>

										</a>
									</td>

							    </tr>

							<?php endforeach; ?>
							
						</tbody>
					
					</table>
	            
	            </div>
	            
         	</div>

        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>