<?php $__env->startSection('title', tr('providers')); ?>

<?php $__env->startSection('content-header', tr('providers')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-users"></i> <?php echo e(tr('providers')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">

        <div class="col-xs-12">

          	<div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
                
                	<b><?php echo e(tr('providers')); ?></b>

	                <a href="<?php echo e(route('admin.providers.create')); ?>" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> <?php echo e(tr('add_provider' )); ?></b>
	                </a>

	                <!-- EXPORT OPTION START -->

					<?php if( count( $providers ) > 0 ): ?>
	                
		                <ul class="admin-action btn btn-danger pull-right" style="margin-right: 20px">
		                 	
							<li class="dropdown">
				                <a class="dropdown-toggle text-white" data-toggle="dropdown" href="#">
				                  	<b><?php echo e(tr('export')); ?> <span class="caret"></span></b>
				                </a>
				                <ul class="dropdown-menu">
				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.providers.export' , ['format' => 'xls'])); ?>">
				                  			<span class="text-red"><b><?php echo e(tr('excel_sheet')); ?></b></span>
				                  		</a>
				                  	</li>

				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.providers.export' , ['format' => 'csv'])); ?>">
				                  			<span class="text-blue"><b><?php echo e(tr('csv')); ?></b></span>
				                  		</a>
				                  	</li>
				                </ul>
							</li>
						</ul>

					<?php endif; ?>

		            <!-- EXPORT OPTION END -->
            	</div>
            
	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      	<th><?php echo e(tr('id')); ?></th>

						      	<th><?php echo e(tr('name')); ?></th>

						      	<th><?php echo e(tr('email')); ?></th>

						      	<th><?php echo e(tr('mobile')); ?></th>
						      	
						      	<th><?php echo e(tr('provider_payout')); ?></th>

						      	<?php if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON): ?>
							      	<th><?php echo e(tr('email_verification')); ?></th>
							    <?php endif; ?>

						      	<th><?php echo e(tr('status')); ?></th>

						      	<?php if(Setting::get('redeem_control')): ?>
						      	
						      	<th><?php echo e(tr('redeems')); ?></th>

						      	<?php endif; ?>

						      	<th><?php echo e(tr('action')); ?></th>

						    </tr>

						</thead>

						<tbody>

							<?php foreach( $providers as $i => $provider_details): ?>

							    <tr>
							      	<td><?php echo e(showEntries($_GET,$i+1)); ?></td>

							      	<td>
							      		<a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $provider_details->id])); ?>"> 
							      			<?php echo e($provider_details->name); ?>


							      			<?php if( $provider_details->is_available == PROVIDER_AVAILABLE ): ?>
							      				<span class="text-green pull-right"><i class="fa fa-circle text-success"></i></span>

							      			<?php else: ?>
							      				<span class="text-red pull-right"><i class="fa fa-circle"></i></span>

							      			<?php endif; ?>
							      		</a>
							      	</td>

							      	<td><?php echo e($provider_details->email); ?></td>

							      	<td><?php echo e($provider_details->mobile); ?></td>

							      	<td>
							      		<?php if($provider_details->providerPayment): ?>

							      			<?php

							      				$amount_details = get_provider_amount($provider_details->id);

							      				$provider_amount = $amount_details ? $amount_details->provider_amount : "0.00";

							      				$payout = $provider_amount - $provider_details->providerPayment->cod; 

			                					$payout = $payout - $provider_details->providerPayment->paid_amount; 

							      			?>

							      			<?php echo e(Setting::get('currency')); ?> <?php echo e($payout ? $payout : 0.00); ?>


							      		<?php else: ?>
							      			<?php echo e(Setting::get('currency')); ?> 0.00
							      		<?php endif; ?>					 
							      	</td>

							      	<?php if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON): ?>

								      	<td>

									      	<?php if($provider_details->is_verified == PROVIDER_EMAIL_NOT_VERIFIED): ?>

									      		<a href="<?php echo e(route('admin.providers.verify' , ['provider_id' => $provider_details->id])); ?>" class="btn btn-xs btn-success" onclick="return confirm(&quot;<?php echo e($provider_details->name); ?> - <?php echo e(tr('provider_email_confirmation')); ?>&quot;);"><?php echo e(tr('verify')); ?></a>

									      	<?php else: ?>

									      		<span><?php echo e(tr('verified')); ?></span>

									      	<?php endif; ?>
								      	
								    	</td>

								    <?php endif; ?>

							      	<td>
							      		<?php if($provider_details->is_approved == PROVIDER_APPROVED): ?>

							      			<span class="label label-success text-uppercase"><?php echo e(tr('approved')); ?></span>

							       		<?php elseif($provider_details->is_approved == PROVIDER_STATUS_PENDING): ?>

							       			<span class="label label-warning text-uppercase"><?php echo e(tr('pending')); ?></span>

							       		<?php else: ?>
							       			<span class="label label-danger text-uppercase"><?php echo e(tr('declined')); ?></span>
							       		<?php endif; ?>
							       	</td>

							       	<?php if(Setting::get('redeem_control')): ?>

							       		<td><b><?php echo e(Setting::get('currency')); ?> <?php echo e($provider_details->providerPayment ? number_format($provider_details->providerPayment->wallet , 2) : "0.00"); ?></b></td>

							       	<?php endif; ?>

									<td>

										<div class="dropdown <?php if($i < 2): ?> dropdown <?php else: ?> dropup <?php endif; ?>">
											
											<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
												<?php echo e(tr('action')); ?>

												<span class="caret"></span>
											</button>

											<ul class="dropdown-menu" aria-labelledby="dropdownMenu">

												<li>
													<a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $provider_details->id])); ?>"><b><?php echo e(tr('view')); ?></b></a>
												</li>

												<?php if(Setting::get('admin_demo_control')): ?>

													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left;"><b><?php echo e(tr('edit')); ?></b></a>
													</li>

													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('delete')); ?></b></a>	
													</li>

												<?php else: ?>

													<li>

														<a href="<?php echo e(route('admin.providers.edit' ,['provider_id' => $provider_details->id])); ?>"><b><?php echo e(tr('edit')); ?></b></a>

													</li>

													<li>
														<a onclick="return confirm(&quot;<?php echo e(tr('admin_provider_delete_confirmation' , $provider_details->name)); ?>&quot;);" href="<?php echo e(route('admin.providers.delete', ['provider_id' => $provider_details->id])); ?>"><b><?php echo e(tr('delete')); ?></b></a>

													</li>

												<?php endif; ?>																	
												<li role="separator" class="divider"></li>

												<?php if(in_array($provider_details->is_approved , [PROVIDER_STATUS_PENDING , PROVIDER_DECLINED])): ?>

													<li>
							                  			<a href="<?php echo e(route('admin.providers.approve' ,  ['provider_id' => $provider_details->id])); ?>" class="text-green">
							                  				<b><?php echo e(tr('approve')); ?></b>
							                  			</a>
							                  		</li>

							                  	<?php else: ?>

							                  		<li>
							                  			<a href="<?php echo e(route('admin.providers.approve' , ['provider_id' => $provider_details->id])); ?>" onclick="return confirm(&quot;<?php echo e($provider_details->name); ?> - <?php echo e(tr('provider_decline_confirmation')); ?>&quot;);">
							                  				<b><?php echo e(tr('decline')); ?></b>
							                  			</a>
							                  		</li>

							                  	<?php endif; ?>
							              
												<li role="separator" class="divider"></li>

												<li>
								              		<a href="<?php echo e(route('admin.providers.services' , ['provider_id' => $provider_details->id] )); ?>">
								              			<b><?php echo e(tr('services')); ?></b>
								              		</a>
								              	</li>

								              	<li>
								              		<a href="<?php echo e(route('admin.providers.gallery' , ['provider_id' => $provider_details->id])); ?>">
								              			<b><?php echo e(tr('gallery')); ?></b>
								              		</a>
								              	</li>


												<?php if(Setting::get('redeem_control')): ?>

													<li>
														<a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.providers.redeems' , $provider_details->id)); ?>"><b><?php echo e(tr('redeems')); ?></b></a>
													</li>

													<li role="separator" class="divider"></li>

												<?php endif; ?>

												<li>
								              		<a href="<?php echo e(route('admin.providers.document', ['provider_id' => $provider_details->id] )); ?>">
								              			<b><?php echo e(tr('documents')); ?></b>
								              		</a>
								              	</li>

								              	<li>
								              		<a href="<?php echo e(route('admin.providers.history' , ['provider_id' => $provider_details->id])); ?>">
								              			<b><?php echo e(tr('view_history')); ?></b>
								              		</a>
								              	</li>

								              	<li>	
              										<a href="<?php echo e(route('admin.provider_subscriptions.plans' , ['provider_id' => $provider_details->id])); ?>" >
								              		<b><?php echo e(tr('plans')); ?></b>
								              		</a>	       		
								              	</li>    	

								              	<li>	
              										<a href="<?php echo e(route('admin.providers.dashboard' , ['provider_id' => $provider_details->id])); ?>" >
								              		<b><?php echo e(tr('dashboard')); ?></b>
								              		</a>	       		
								              	</li>

											</ul>

										</div>
									</td>
							    </tr>
							<?php endforeach; ?>
						</tbody>
					
					</table>
					<div align="right"><?php echo e($providers->links()); ?></div>
	            
	            </div>

          	</div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>