<?php $__env->startSection('title', tr('view_history')); ?>

<?php $__env->startSection('content-header'); ?>
<?php echo e(tr('view_history')); ?> -  <?php echo e($user_details->name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li><a href="<?php echo e(route('admin.users.index')); ?>"><i class="fa fa-user"></i> <?php echo e(tr('users')); ?></a></li>
    <li class="active"> <?php echo e(tr('view_history')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">
	
        <div class="col-xs-12">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">

	                <b><?php echo e(tr('history')); ?></b>

	                <a href="<?php echo e(route('admin.users.index')); ?>" style="float:right" class="btn btn-warning"><b><i class="fa fa-eye"></i> <?php echo e(tr('view_users')); ?></b></a>

	            </div>

	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      	<th><?php echo e(tr('id')); ?></th>
						      	<th><?php echo e(tr('title')); ?></th>
						      	<th><?php echo e(tr('provider')); ?></th>
						      	<th><?php echo e(tr('job_type')); ?></th>
						      	<th><?php echo e(tr('request_date')); ?></th>
						      	<th><?php echo e(tr('price_per_hour')); ?></th>
                                <th><?php echo e(tr('payment_mode')); ?></th>						      	
						      	<th><?php echo e(tr('total')); ?></th>
						      	<th><?php echo e(tr('action')); ?></th>
						    </tr>
						</thead>

						<tbody>

							<?php foreach($history as $i => $history_details): ?>

							    <tr>
							      	<td><?php echo e(showEntries($_GET,$i + 1)); ?></td>

                                    <td>
                                    	<a href="<?php echo e(route('admin.requests.view' ,['request_unique_id' =>  $history_details->unique_id] )); ?>"> <?php echo e($history_details->name); ?></a>
                                    </td>

							      	<td><?php if($history_details->provider): ?> <a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $history_details->provider_id])); ?>"><?php echo e($history_details->provider->name); ?></a> <?php endif; ?>
							      	</td>

							      	<td><?php echo e(job_type($history_details->job_type)); ?></td>

							      	<td><?php echo e(common_date($history_details->request_date , Auth::guard('admin')->user()->timezone)); ?></td>

							      	<td>
							      		<?php echo e($history_details->currency); ?> <?php echo e($history_details->price_per_hour); ?><?php echo e($history_details->price_per_symbol); ?>

							      	</td>

							      	<td><?php echo e($history_details->payment_mode); ?></td>

							      	<td>
							      		<?php echo e($history_details->currency); ?> <?php echo e($history_details->total); ?>

							      	</td>

								    <td>
	        							<a class="btn btn-success" href="<?php echo e(route('admin.requests.view' , ['request_unique_id' => $history_details->unique_id] )); ?>"><i class="fa fa-eye"></i> <?php echo e(tr('view')); ?></a>
								    </td>

							    </tr>					

							<?php endforeach; ?>

						</tbody>
					
					</table>

					<div align="right"><?php echo e($history->appends(['user_id' => $user_details->id])->links()); ?></div>
					
	            </div>

          	</div>

        </div>

    </div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>