<?php $__env->startSection('title', tr('sub_categories')); ?>

<?php $__env->startSection('content-header'); ?>

<?php echo e(tr('sub_categories')); ?>


	<?php if($category_details): ?>

	<a href="<?php echo e(route('admin.categories.index')); ?>">
		- <?php echo e($category_details->name); ?>

	</a>

	<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-suitcase"></i> <?php echo e(tr('sub_categories')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<div class="row">
    
    <div class="col-xs-12">
        
        <div class="box box-success">

           	<div class="box-header with-border admin-panel-success">

                <b><?php echo e(tr('sub_categories')); ?></b>

                <a href="<?php echo e(route('admin.sub_categories.create')); ?>" style="float:right" class="btn btn-warning">
                	<b><i class="fa fa-plus"></i> <?php echo e(tr('add_sub_category')); ?></b>
                </a>
                
            </div>
            
            <div class="box-body">

				<?php if(count($sub_category) > 0): ?>

					<div class="table table-responsive">

		              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

							<thead>
							    <tr>
							      <th><?php echo e(tr('id')); ?></th>
							      <th><?php echo e(tr('sub_category')); ?></th>
							      <th><?php echo e(tr('category')); ?></th>
							      <th><?php echo e(tr('price')); ?></th>
							      <th><?php echo e(tr('status')); ?></th>
							      <th><?php echo e(tr('image')); ?></th>
							      <th><?php echo e(tr('action')); ?></th>
							    </tr>
							</thead>

							<tbody>

								<?php foreach($sub_category as $i => $sub_category_details): ?>

								    <tr>
	                                    <td><?php echo e(showEntries($_GET,$i + 1)); ?></td>
								      	
								      	<td><?php echo e($sub_category_details->name); ?></td>
								      	
								      	<td>
								      		<?php if($sub_category_details->category): ?> 
								      		<?php echo e($sub_category_details->category->name); ?>

								      		<?php else: ?>
								      		<?php echo e(tr('category_not_available')); ?>

								      		<?php endif; ?>
								      	</td>
								      	
								      	<td><?php echo e(Setting::get('currency')); ?> <?php echo e($sub_category_details->price); ?></td>

								      	<td>
								      		<?php if( $sub_category_details->status == COMMON_APPROVED): ?>
								      			<span class="label label-success"><?php echo e(tr('approved')); ?></span>
								       		<?php else: ?>
								       			<span class="label label-warning"><?php echo e(tr('pending')); ?></span>
								       		<?php endif; ?>
								       </td>
								      	
							      		<td>
		                                	<img style="height: 30px;" src="<?php echo e($sub_category_details->picture); ?>">
		                            	</td>
								      	
									    <td>

									    	<div class="dropdown">
											
												<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
													<?php echo e(tr('action')); ?>

													<span class="caret"></span>
												</button>

												<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
												
													<?php if(Setting::get('admin_demo_control')): ?>
														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left;">	<b><?php echo e(tr('edit')); ?></b>
															</a>
														</li>
														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left">
									                  			<b><?php echo e(tr('delete')); ?></b>
									                  		</a>
														</li>
													<?php else: ?>
														<li>
															<a href="<?php echo e(route('admin.sub_categories.edit' , ['sub_category_id' =>  $sub_category_details->id] )); ?>"><b><?php echo e(tr('edit')); ?></b></a>
														</li>
														<li>
															<a 
															onclick="return confirm(&quot;<?php echo e(tr('admin_sub_category_delete_confirmation' , $sub_category_details->name)); ?>&quot;)"
															href="<?php echo e(route('admin.sub_categories.delete' , ['sub_category_id' =>  $sub_category_details->id] )); ?>"><b><?php echo e(tr('delete')); ?></b></a>
														</li>
													<?php endif; ?>
																											
													<li class="divider" role="presentation"></li>

								                  	<?php if( $sub_category_details->status == COMMON_APPROVED): ?>
								                  		<li>
								                  			<a 
								                  			onclick="return confirm(&quot;<?php echo e($sub_category_details->name); ?> - <?php echo e(tr('sub_category_decline_confirmation')); ?>&quot;);"
								                  			href="<?php echo e(route('admin.sub_categories.status' , ['sub_category_id' =>  $sub_category_details->id] )); ?>">
								                  				<b><?php echo e(tr('decline')); ?></b>
								                  			</a>
								                  		</li>
								                  	<?php else: ?>
								                  		<li>
								                  			<a href="<?php echo e(route('admin.sub_categories.status' ,['sub_category_id' =>  $sub_category_details->id] )); ?>">
								                  				<b><?php echo e(tr('approve')); ?></b>
								                  			</a>
								                  		</li>
								                  	<?php endif; ?>

													<li class="divider" role="presentation"></li>

												</ul>

											</div>

									    </td>

								    </tr>

								<?php endforeach; ?>
							
							</tbody>
					
						</table>
					
						<div align="right"><?php echo e($sub_category->links()); ?></div>
					
					</div>

				<?php else: ?>
					<h3 class="no-result"><?php echo e(tr('no_sub_category_found')); ?></h3>
				<?php endif; ?>
			
            </div>

      	</div>

    </div>
    
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>