<?php $__env->startSection('title', tr('ondemand_requests')); ?>

<?php $__env->startSection('content-header', tr('ondemand_requests')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-map"></i> <?php echo e(tr('ondemand_requests')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">

        <div class="col-xs-12">
    
            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b><?php echo e(tr('ondemand_requests')); ?></b>

                    <!-- EXPORT OPTION START -->

                    <?php if(count($requests) > 0 ): ?>
                    
                        <ul class="admin-action btn btn-warning pull-right" style="margin-right: 40px">
                            
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                  <b> <?php echo e(tr('export')); ?> </b> <span class="caret"></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.requests.export' , ['job_type'=> REQUEST_NOW,'format' => 'xlsx'])); ?>">
                                            <span class="text-red"><b><?php echo e(tr('excel_sheet')); ?></b></span>
                                        </a>
                                    </li>

                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.requests.export' , ['job_type'=> REQUEST_NOW,'format' => 'csv'])); ?>">
                                            <span class="text-blue"><b><?php echo e(tr('csv')); ?></b></span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            
                        </ul>

                    <?php endif; ?>

                <!-- EXPORT OPTION END -->
                </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                                <th><?php echo e(tr('s_no')); ?></th>
                                <th><?php echo e(tr('title')); ?></th>                                
                                <th class="min"><?php echo e(tr('user')); ?></th>
                                <th class="min"><?php echo e(tr('provider')); ?></th>
                                <th class="min"><?php echo e(tr('request_date')); ?></th>
                                <th><?php echo e(tr('status')); ?></th>
                                <th><?php echo e(tr('total')); ?></th>
                                <th><?php echo e(tr('action')); ?></th>
                            </tr>
                        </thead>

                        <tbody>

                            <?php foreach($requests as $index => $request_details): ?>
                            
                                <tr>

                                    <td><?php echo e(showEntries($_GET,$index + 1)); ?></td>

                                    <td> 
                                        <a href="<?php echo e(route('admin.requests.view' , ['request_unique_id' => $request_details->unique_id] )); ?>"><?php echo e($request_details->name); ?></a>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('admin.users.view' , ['user_id' => $request_details->user_id] )); ?>"><?php echo e($request_details->user->name ?? tr('user_not_available')); ?></a>
                                    </td>

                                    <td>
                                        <?php if($request_details->provider_id): ?>
                                            <a href="<?php echo e(route('admin.providers.view' ,['provider_id' =>  $request_details->provider_id ])); ?>"><?php echo e($request_details->provider ? $request_details->provider->name : ""); ?> </a>
                                        <?php else: ?> 
                                            - 
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php echo e(common_date($request_details->request_date, Auth::guard('admin')->user()->timezone)); ?>

                                    </td>

                                    <td><?php echo e(request_status($request_details->status)); ?></td>

                                    <td><?php echo e($request_details->currency); ?> <?php echo e($request_details->total); ?></td>

                                    <td>
                                        <a href="<?php echo e(route('admin.requests.view' , ['request_unique_id' => $request_details->unique_id] )); ?>" class="btn btn-success"><i class="fa fa-eye"></i> <b><?php echo e(tr('view')); ?></b></a>

                                        <?php $allowed_cancel_status = [PROVIDER_NONE,PROVIDER_ASSIGNED,PROVIDER_ACCEPTED,PROVIDER_STARTED];
                                            ?>

                                        <?php if(in_array($request_details->provider_status, $allowed_cancel_status)): ?> 

                                            <?php if($request_details->status != REQUEST_CANCELLED ): ?>
                                                                                       
                                                <a data-toggle="modal" data-target="#<?php echo e($request_details->id); ?>_cancel_request" class="pull-right btn btn-sm btn-danger"> <?php echo e(tr('cancel')); ?> </a>
                                            <?php endif; ?>
      
                                        <?php endif; ?>
                                            
                                            <div class="modal fade error-popup" id="<?php echo e($request_details->id); ?>_cancel_request" role="dialog">

                                                <div class="modal-dialog">

                                                    <div class="modal-content">

                                                        <form method="post" action="<?php echo e(route('admin.requests.cancel', ['request_id' => $request_details->id])); ?>">

                                                            <div class="modal-body">

                                                                <div class="media">

                                                                    <div class="media-body">

                                                                       <h4 class="media-heading"><?php echo e(tr('reason')); ?> *</h4>

                                                                       <textarea rows="5" name="cancel_reason" id='cancel_reason' required style="width: 100%"></textarea>

                                                                   </div>

                                                                </div>

                                                                <div class="text-right">

                                                                    <br>

                                                                   <button type="submit" class="btn btn-primary top"><?php echo e(tr('submit')); ?></button>

                                                               </div>

                                                            </div>

                                                        </form>

                                                    </div>

                                                </div>

                                            </div>

                                    </td>
                                
                                </tr>
                            
                            <?php endforeach; ?>
                        
                        </tbody>

                    </table>

                    <div align="right"><?php echo e($requests->links()); ?></div>

                </div>

            </div>

        </div>
    
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>