<?php $__env->startSection('after-styles'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('common/css/grid-gallery.css')); ?>">

<style>

	.switch {
		position: relative;
		display: inline-block;
		width: 60px;
		height: 34px;
	}

	.switch input {display:none;}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 26px;
		width: 26px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
	}

	input:checked + .slider {
		background-color: #51af33;
	}

	input:focus + .slider {
		box-shadow: 0 0 1px #2196F3;
	}

	input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
	}

	/* Rounded sliders */
	.slider.round {
		border-radius: 34px;
	}

	.slider.round:before {
		border-radius: 50%;
	}

	.block{
        text-align: center;
        vertical-align: middle;
    }
    .circle{
        background: #51af33;
        border-radius: 50%;
        color: white;
        height: 150px;
        font-weight: bold;
        width: 150px;
    }
	.circle span{
		display: table-cell;
		padding-top:40%;
		font-size: 20px;
	}

	.card-button {
		margin-left: 4%;
		margin-top: 3%;

	}
	.redeem-image{
		background-position: center;
		background-size: cover;
		background-repeat: no-repeat;
		height: 200px;
		width: 200px;
		margin: 0 auto;
		display: flex;
		align-items: center;
		justify-content: center;
	}

</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30">
		
		<div class="container">

		    <?php if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING): ?>
		    
		        <div class="alert alert-danger text-uppercase">
		            <?php echo e(tr('provider_waiting_for_admin_approval')); ?>

		        </div>

		    <?php endif; ?>			    

			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			<?php if( Auth::guard('provider')->user()->step == PROVIDER_STEP_COMPLETE): ?>

			    <h3 class="dashboard-main-tit"><?php echo e(tr('your_account')); ?></h3>
			
			<?php endif; ?>
			<!-- Dashboard Left -->
			<div class="dashboard-left-col col-lg-3 col-md-3 col-sm-12 col-xs-12">
			
				<div class="dashboard-left">
					<!-- Nav tabs -->
					
					<?php echo $__env->make('provider.account.profile-nav', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

				</div>

			</div>
			<!-- end of dashboard left -->

			<!-- Dashboard Right -->

			<div class="dashboard-right-col col-lg-9 col-md-9 col-sm-12 col-xs-12">
				
				<div class="dashboard-right tab-content white-bg p-f-30">
					
					<!-- Profile Tab -->

					<?php echo $__env->make('provider.account.sub_pages.profile', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

					<!-- Profile Tab -->

					<!-- document tab -->

					<?php echo $__env->make('provider.account.sub_pages.document', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

					<!-- End of document tab -->
					
					<!-- Billing Tab -->

					<?php echo $__env->make('provider.account.sub_pages.billing', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

					<!-- Billing Tab -->

					<?php if(Setting::get('redeem_control')): ?>

						<?php echo $__env->make('provider.account.sub_pages.redeems', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

					<?php endif; ?>

					<!-- Change-pwd tab -->
					
					<?php echo $__env->make('provider.account.sub_pages.change-password', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

					<!-- End of Change-pwd tab -->

					<!-- Delete account tab -->
					
					<?php echo $__env->make('provider.account.sub_pages.delete-account', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

					<!-- End of Delete account tab -->
				</div>
				
			</div>
			<!-- End of dashboard right -->
		
		</div>
	
	</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>

<script type="text/javascript">

	document.getElementById("uploadBtn").onchange = function () {
	    document.getElementById("uploadFile").value = this.value;
	};
	
	document.getElementById("uploadBtn1").onchange = function () {
	    document.getElementById("uploadFile1").value = this.value;
	};

</script>

<script>
	
	function change_availability() {

		var url = "<?php echo e(route('provider.detect.request')); ?>";

		var id = "<?php echo e(Auth::guard('provider')->user()->id); ?>";
		var token = "<?php echo e(Auth::guard('provider')->user()->token); ?>";

		var change_availability = 1;

		$.ajax({
			url : url,
			method : "GET",
			data : {id : id , token : token},
			success : function(result) {

				if(result.success) {
					if(result.data) {
						change_availability = 0; 
					}
				}
			}

		});

		if(change_availability) {

			if($('#change_availability').is(':checked')) {

				$.ajax({url: "<?php echo e(route('provider.change.state')); ?>", method: "POST",  data: { status : 1 }, success: function(result){
			    	}
			    });

			} else {
				$.ajax({url: "<?php echo e(route('provider.change.state')); ?>", method: "POST",  data: { status : 0 }, success: function(result) {
			    	}
				});
			}
		} else {
			alert('Ongoing request.');
		}

	}

	function check_document_upload() {

	    data = $('#documents-data');

	    for (var i = 0; i < $("#documents-data").get(0).files.length; ++i) {

	        var documents_data=$("#documents-data").get(0).files[i].name;

	        if(documents_data) { 

	            var file_size=$("#documents-data").get(0).files[i].size;

	            console.log(file_size);

	            if(file_size < 53810750) {

	                var ext = documents_data.split('.').pop().toLowerCase(); 

	                console.log(ext);

	                if($.inArray(ext,['jpg','jpeg','gif' , 'pdf' , 'png'])===-1) {

	                    $('#documents-data-error').text("Invalid file extension : accepted formats : .png , .jpeg , .jpg, .gif , .pdf")

	                    data.replaceWith(data.val('').clone(true));

	                    return false;

	                } else {
	                    $('#documents-data-error').text("");
	                }

	            } else {

	                $('#documents-data-error').text("The upload file exists the max file size limit: Max - 50MB");

	                data.replaceWith(data.val('').clone(true));

	                return false;
	            
	            } 
	        }
	    
	    }

	}

</script>

<script type="text/javascript" src="<?php echo e(asset('common/js/grid-gallery.min.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.provider', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>