<?php $__env->startSection('title', tr('view_provider')); ?>

<?php $__env->startSection('content-header', tr('view_provider')); ?>

<?php $__env->startSection('breadcrumb'); ?>

    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>

    <li><a href="<?php echo e(route('admin.providers.index')); ?>"><i class="fa fa-users"></i> <?php echo e(tr('providers')); ?></a></li>

    <li class="active"> <?php echo e(tr('view_provider')); ?></li>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>

<link rel="stylesheet" href="<?php echo e(asset('assets/css/star-rating.css')); ?>">

<style>
	
	dt {
		padding: 4px !important; 
	}

	dd {
		padding: 4px !important;
	}

	table {
	    font-family: arial, sans-serif;
	    border-collapse: collapse;
	    width: 100%;
	}

	td, th {
	    border: 1px solid #dddddd;
	    text-align: left;
	    padding: 8px;
	}

	tr:nth-child(even) {
	    background-color: #28ae5217;
	}

	td:nth-child(odd) {
	    color:#0000008a;
	}

	.rv-desc {
		line-height: 1.6;
	    letter-spacing: 0.6px;
	    font-size: 14px;
	}

	.timeline::before {
	    content: '';
	    position: absolute;
	    top: 0;
	    bottom: 0;
	    width: 0;
	    background: #fff;
	    left: 0px;
	    margin: 0;
	    border-radius: 0px;
	}

</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<div class="row">

		<div class="col-md-11">

			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

		</div>

	</div>
	
	<div class="row">

		<div class="col-md-6">

    		<div class="box box-widget widget-user-2">

            	<div class="widget-user-header bg-green-gradient">
              		<div class="widget-user-image">
                		<img class="img-circle" src="<?php if( $provider_details->picture): ?> <?php echo e($provider_details->picture); ?> <?php else: ?> <?php echo e(asset('admin-css/dist/img/avatar.png')); ?> <?php endif; ?>" alt="User Avatar">
              		</div>

              		<h3 class="widget-user-username"><b><?php echo e($provider_details->name); ?> </b></h3>

      				<h5 class="widget-user-desc"><b><?php echo e(tr('provider')); ?></b></h5>

      				<p>
      					<input id="view_rating" name="rating" type="number" class="rating view_rating" min="1" max="5" step="1" value="<?php echo e(provider_rating( $provider_details->id)); ?>">
      				</p>
            	</div>

            	<div class="box-footer no-padding">

            		<p style="margin: 10px">
            			<?php echo e($provider_details->description); ?>

            		</p>

            		<table>
					    
				    	<tr>
					        <td><?php echo e(tr('name')); ?></td>
					        <td><?php echo e($provider_details->name); ?></td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('email')); ?></td>

					        <td> 
					        	<?php echo e($provider_details->email); ?> 
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('paypal_email')); ?></td>

					        <td> 
					        	<?php echo e($provider_details->paypal_email); ?> 
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('mobile')); ?></td>

					        <td> 
					        	<?php echo e($provider_details->mobile); ?> 
					        </td>
					    </tr>

					    <tr>
					    	<td><?php echo e(tr('status')); ?></td>

					    	<td>

			                    <?php if( $provider_details->is_approved == PROVIDER_APPROVED): ?>

					      			<span class="label label-success text-uppercase"> 
					      				<i class="fa fa-check-circle"></i> <?php echo e(tr('approved')); ?>

					      			</span>

					       		<?php elseif( $provider_details->is_approved == PROVIDER_STATUS_PENDING): ?>

					       			<span class="label label-warning text-uppercase">
					       				<i class="fa fa-times"></i> <?php echo e(tr('pending')); ?>

					       			</span>

					       		<?php else: ?>
					       			<span class="label label-danger text-uppercase">
					       				<i class="fa fa-times"></i> <?php echo e(tr('declined')); ?>

					       			</span>
					       		<?php endif; ?>
					    	</td>
					    </tr>

					    <tr>
					    	<td><?php echo e(tr('is_verified')); ?></td>

					    	<td>
							   	<?php if( $provider_details->is_verified == PROVIDER_EMAIL_VERIFIED): ?>
			                       	
			                       	<span class="text-green text-uppercase"><i class="fa fa-check-circle"></i> <?php echo e(tr('yes')); ?></span>

			                    <?php else: ?>
			                    	
			                    	<span class="text-red text-uppercase"><i class="fa fa-times"></i> <?php echo e(tr('no')); ?></span>

			                    <?php endif; ?>
					    	</td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('payment_mode')); ?></td>

					        <td> 
					        	<?php echo e($provider_details->payment_mode); ?> 
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('device_type')); ?></td>

					        <td> 
					        	<span class="text-uppercase"><?php echo e($provider_details->device_type); ?> </span>
					        </td>
					    </tr>			    

					    <tr>
					        <td><?php echo e(tr('login_by')); ?></td>

					        <td> 
					        	<span class="text-uppercase"><?php echo e($provider_details->login_by); ?> </span>
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('login_status')); ?></td>

					        <td> 
					        	<span class="text-uppercase"><?php echo e($provider_details->login_status); ?> </span>
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('register_type')); ?></td>

					        <td> 
					        	<span class="text-uppercase"><?php echo e($provider_details->register_type); ?> </span>
					        </td>
					    </tr>

					    <tr>
					        <td><?php echo e(tr('timezone')); ?></td>

					        <td> 
					        	<?php echo e($provider_details->timezone); ?> 
					        </td>
					    </tr>

					    <tr>
					    	<td style="width: 40%"><?php echo e(tr('waiting_to_respond')); ?></td>

					    	<td>
	                			<?php if( $provider_details->waiting_to_respond == WAITING_TO_RESPOND): ?> 
					      			<span class="label label-success text-uppercase"><?php echo e(tr('yes')); ?></span>
					       		<?php else: ?> 
					       			<span class="label label-warning text-uppercase"><?php echo e(tr('no')); ?></span>
					       		<?php endif; ?>
					    	</td>
					    </tr>

					    <tr>
					    	<td><?php echo e(tr('available')); ?></td>
					    	<td>
					    		<?php if( $provider_details->is_available == PROVIDER_AVAILABLE && $provider_details->is_approved == PROVIDER_APPROVED): ?> 
					      			<span class="label label-success text-uppercase"><?php echo e(tr('yes')); ?></span>
					       		<?php else: ?> 
					       			<span class="label label-warning text-uppercase"><?php echo e(tr('no')); ?></span>
					       		<?php endif; ?>
					    	</td>
					    </tr>

					    <tr>
					    	<td><?php echo e(tr('video')); ?></td>
					    	<td>
					    		<?php if( $provider_details->video): ?>

					    			<a href="<?php echo e($provider_details->video); ?>" target="_blank"><?php echo e(tr('view_video')); ?></a>

					    		<?php else: ?>

					    			-

					    		<?php endif; ?>
					    	</td>
					    </tr>

					    <tr>
					    	<td><?php echo e(tr('gallery')); ?></td>
					    	<td>
					    		
					    		<a href="<?php echo e(route('admin.providers.gallery' , ['provider_id' =>  $provider_details->id])); ?>" target="_blank">
					    			<?php echo e(tr('view_gallery')); ?>

					    		</a>

					    	</td>
					    </tr>

					    <tr>
					    	<td><?php echo e(tr('joined')); ?></td>
					    	<td>
					    		<?php echo e(common_date( $provider_details->created_at , Auth::guard('admin')->user()->timezone)); ?>

					    	</td>
					    </tr>

					    <tr>
					    	<td><?php echo e(tr('updated_at')); ?></td>
					    	<td>
					    		<?php echo e(common_date( $provider_details->updated_at , Auth::guard('admin')->user()->timezone)); ?>

					    	</td>
					    </tr>

					</table>
            	
            	</div>

            	<div class="box-footer">

					<?php if(Setting::get('admin_demo_control')): ?>

						<a href="javascript:;" class="btn disabled" style="text-align: left;" class="btn btn-warning  text-center"><b><?php echo e(tr('edit')); ?></b></a>

						<a href="javascript:;" class="btn disabled" style="text-align: left" class="btn btn-danger text-center"><b><?php echo e(tr('delete')); ?></b></a>	

					<?php else: ?>

						<a href="<?php echo e(route('admin.providers.edit' ,['provider_id' => $provider_details->id])); ?>" class="btn btn-warning  text-center"><b><?php echo e(tr('edit')); ?></b></a>

						<a onclick="return confirm(&quot;<?php echo e(tr('admin_provider_delete_confirmation' , $provider_details->name)); ?>&quot;);" href="<?php echo e(route('admin.providers.delete', ['provider_id' => $provider_details->id])); ?>" class="btn btn-danger text-center"><b><?php echo e(tr('delete')); ?></b></a>

					<?php endif; ?>

					<?php if(in_array($provider_details->is_approved , [PROVIDER_STATUS_PENDING , PROVIDER_DECLINED])): ?>

              			<a href="<?php echo e(route('admin.providers.approve' , ['provider_id' => $provider_details->id])); ?>" class="btn btn-success text-center ">
              				<b><?php echo e(tr('approve')); ?></b>
              			</a>
                  	<?php else: ?>

              			<a href="<?php echo e(route('admin.providers.approve' ,['provider_id' => $provider_details->id])); ?>" onclick="return confirm(&quot;<?php echo e($provider_details->name); ?> - <?php echo e(tr('provider_decline_confirmation')); ?>&quot;);" class="btn btn-danger text-center ">
              				<b><?php echo e(tr('decline')); ?></b>
              			</a>

                  	<?php endif; ?>

                  	<a href="<?php echo e(route('admin.providers.history' , ['provider_id' => $provider_details->id])); ?>" class="btn btn-info text-center pull-right">
              			<b><?php echo e(tr('view_history')); ?></b>
              		</a>

              		<a href="<?php echo e(route('admin.provider_subscriptions.plans' , ['provider_id' => $provider_details->id])); ?>" class="btn btn-success text-center pull-right" style="margin-right: 4px;">
              			<b><?php echo e(tr('plans')); ?></b>
              		</a>

            	</div>
          	
          	</div>

		</div>

		<div class="col-md-5">

			<div class="box box-success">

                <div class="box-header with-border admin-panel-success">
					<h4 class="text-uppercase"><b><?php echo e(tr('provider_location')); ?></b></h4>
				</div>

				<div class="box-body">

					<p><?php echo e($provider_details->address); ?></p>
					<p><?php echo e(tr('latitude')); ?>: <?php echo e($provider_details->latitude); ?></p>
					<p><?php echo e(tr('longitude')); ?>: <?php echo e($provider_details->longitude); ?></p>

					<img src='https://maps.googleapis.com/maps/api/staticmap?center=<?php echo e($provider_details->latitude); ?>,<?php echo e($provider_details->longitude); ?>&zoom=19&size=400x200&markers=color:dark-green%7Clabel:S%7C<?php echo e($provider_details->latitude); ?>,<?php echo e($provider_details->longitude); ?>&markers=size:mid%7Ccolor:0x00a65a%7Clabel:S%7C,AK"&key=<?php echo e(Setting::get('GOOGLE_API_KEY')); ?>' class="img img-responsive img-thumbnail">

				</div>

			</div>

			<div class="clearfix"></div>

    		<div class="box box-widget widget-user-2">

    			<div class="box box-success">

	                <div class="box-header with-border admin-panel-success">
						<h4 class="text-uppercase"><b><?php echo e(tr('provider_payout')); ?></b></h4>
					</div>

	            	<div class="box-footer no-padding">
	            		
	              		<ul class="nav nav-stacked">

	              			<?php if(count( $provider_details->providerPayment) > 0): ?>
	            
			                <li>
			                	<a><b><?php echo e(tr('paypal_email')); ?></b> <span class="pull-right"><?php echo e($provider_details->paypal_email); ?></span></a>
			                </li>

			                <li>
			                	<a><b><?php echo e(tr('cod')); ?></b> <span class="pull-right"><?php echo e(Setting::get('currency')); ?> <?php echo e($provider_details->providerPayment->cod); ?></span></a>
			                </li>
			                
			                <li>
			                	<a><b><?php echo e(tr('card')); ?></b> <span class="pull-right"><?php echo e(Setting::get('currency')); ?> <?php echo e($provider_details->providerPayment->card); ?></span></a>
			                </li>

			                <li>
			                	<a><b><?php echo e(tr('total')); ?></b> <span class="pull-right"><?php echo e(Setting::get('currency')); ?> <?php echo e($provider_details->providerPayment->total); ?></span></a>
			                </li>
			            
			                <li>
			                	<a>
			                		<b><?php echo e(tr('admin_commission')); ?></b>
			                		
			                		<span class="pull-right">
			                			<?php echo e(Setting::get('currency')); ?> <?php echo e($amount_details->admin_amount); ?>

			                		</span>
			                	</a>
			                </li>

			                <li>		                

			                	<a>
			                		<b><?php echo e(tr('provider_amount')); ?></b>
			                		<span class="pull-right">
			                			<?php echo e(Setting::get('currency')); ?> <?php echo e($amount_details->provider_amount); ?>

			                		</span>		                
			                	</a>
			                </li> 
			                
			                <li>
			                	<a style="color: blue"><b><?php echo e(tr('paid')); ?></b> <span class="pull-right"><?php echo e(Setting::get('currency')); ?> <?php echo e($provider_details->providerPayment->paid_amount); ?></span>
			                	</a>
			                </li>

			                <?php 
			                		
		                		$payout = $amount_details->provider_amount -  $provider_details->providerPayment->cod; 

		                		$payout = $payout -  $provider_details->providerPayment->paid_amount; 

		                	?>

			                <li>
			                	<a style="color: brown"><b><?php echo e(tr('pending_amount')); ?></b> 
			                		<span class="pull-right"><?php echo e(Setting::get('currency')); ?> <?php echo e($payout < 0 ? $payout : 0); ?></span>
			                	</a>
			                	
			                </li>

			                <li>
			                	<!--  -->

			                	<a style="color: green">
			                		<b>
			                			<?php echo e(tr('payout')); ?>

			                			<span class="pull-right"><?php echo e(Setting::get('currency')); ?> <?php echo e($payout >= 0 ? $payout : 0); ?></span>
			                		</b> 
			                	</a>
			                </li>

			                <li style="padding: 10px;">
			                	
			                	<form class="" action="<?php if($payout <= 0): ?> #  <?php else: ?> <?php echo e(route('admin.providers.pay')); ?> <?php endif; ?>" method="POST">

			                		<span>

			                			<input type="hidden" name="provider_id" value="<?php echo e($provider_details->id); ?>">
			                			
			                			<input type="hidden" name="payout" value="<?php echo e($payout); ?>">
			                			
			                			<input type="number"  min="1" required name="amount" class="form-control pull-left" style="width: 70%;margin-bottom: 10px" placeholder="<?php echo e(tr('enter_amount_pay')); ?>" onkeydown="return isNumber(event)" <?php if($payout <=0): ?> disabled <?php endif; ?>>

			                			<?php if($payout <=0): ?>

			                				<a href="javascript:void(0);" disabled="true" class="btn btn-success pull-right" style="width: 20%">
			                					<i class="fa fa-thumbs-up"></i> 
			                					<?php echo e(tr('submit')); ?>

			                				</a>

			                			<?php else: ?>

				                			<button type="submit" class="btn btn-success pull-right" style="width: 20%"><i class="fa fa-thumbs-up"></i> <?php echo e(tr('submit')); ?></button>	

			                			<?php endif; ?>

			                		</span>	                		
			                	</form>

			                </li>

			                <?php else: ?> 
			                	<p style="padding: 10px"><?php echo e(tr('no_payment_provider')); ?></p>
			                <?php endif; ?>		          
	              		</ul>
	            	
	            	</div>

	            </div>
          	
          	</div>

          	<?php if($provider_details->promo_video != ''): ?>
          	<div class="col-md-5">

          		<iframe width="400" height="315" src="<?php echo e($provider_details->promo_video); ?>" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
          		
          	</div>
          	<?php endif; ?>
		</div>

    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript" src="<?php echo e(asset('assets/js/star-rating.js')); ?>"></script>

    <script type="text/javascript">
        $('.view_rating').rating({disabled: true, showClear: false});
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>